<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Pagos</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">¿

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
        Gestionar Pagos
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="row col-xl-12 m-0 p-0">
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-idconcepto" class="form-label text-primary"><b>
                                            <h4>Buscar por Concepto</h4>
                                        </b></label>
                                    <select id="txt-idconcepto" name="txt-idconcepto"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-idstudent" class="form-label text-primary"><b>
                                            <h4>Buscar por Estudiante</h4>
                                        </b></label>
                                    <select id="txt-idstudent" name="txt-idstudent" class="form-control form-control-sm"
                                        data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estado_pago" class="form-label text-primary"><b>
                                            <h4>Buscar por Estado</h4>
                                        </b></label>
                                    <select id="txt-estado_pago" name="txt-estado_pago"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                        <option value="" selected disabled>Seleccione una opción</option>
                                        <option value="all">Todos</option>
                                        <option value="1">Pagado</option>
                                        <option value="2">Pendiente</option>
                                        <option value="0">No Pagado</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Pagos</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo Pago
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Estudiante</th>
                                                                <th class="text-center">Concepto</th>
                                                                <th class="text-center">Estado</th>
                                                                
                                                                
                                                                <th class="text-center">Método de Pago</th>
                                                                <th class="text-center">Banco</th>
                                                                <th class="text-center">Nro_Operación</th>
                                                                <th class="text-center">Monto</th>
                                                                <th class="text-center">Comprobante</th>
                                                                <th class="text-center">Boleta</th>
                                                                <th class="text-center">Encargado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar Nuevo Pago</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-2">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <input id="txt-idpago" name="txt-idpago" type="hidden">
                                <div id="div-txt-programa_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-programa_id" class="form-label text-primary">Programa</label>
                                    <select id="txt-programa_id" name="txt-programa_id"
                                        class="default-select form-control form-control-sm">
                                    </select>
                                </div>
                                <div id="div-txt-student_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-student_id" class="form-label text-primary">Estudiante</label>
                                    <select id="txt-student_id" name="txt-student_id"
                                        class="default-select form-control form-control-sm" data-live-search="true"
                                        data-size="8" required>
                                        <option selected disabled value="">Buscar alumno</option>
                                    </select>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-concepto_id" class="form-label text-primary">Concepto</label>
                                    <select id="txt-concepto_id" name="txt-concepto_id"
                                        class="default-select form-control form-control-sm" required>
                                    </select>
                                </div>
                                <div id="div-txt-semester_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3"
                                    style="display: none;">
                                    <label for="txt-semester_id" class="form-label text-primary">Periodo Lectivo</label>
                                    <select id="txt-semester_id" name="txt-semester_id"
                                        class="default-select form-control form-control-sm">
                                    </select>
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha" class="form-label text-primary">Fecha</label>
                                    <input id="txt-fecha" name="txt-fecha" type="date" value="<?php echo e(now()); ?>"
                                        class="form-control form-control-sm" placeholder="" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-monto_inicial" class="form-label text-primary">Monto Inicial</label>
                                    <input id="txt-monto_inicial" name="txt-monto_inicial" type="number"
                                        class="form-control form-control-sm" placeholder="" required readonly>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-exoneration_id" class="form-label text-primary">Exoneración
                                        (Opcional)</label>
                                    <select id="txt-exoneration_id" name="txt-exoneration_id"
                                        class="default-select form-control form-control-sm" data-live-search="true">
                                    </select>
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-monto_final" class="form-label text-primary">Monto Final</label>
                                    <input id="txt-monto_final" name="txt-monto_final" type="number"
                                        class="form-control form-control-sm" placeholder="" required readonly>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                                <div class="col-12 px-0">
                                    <div class="row m-0" id="div-descuento-fields" style="display: none;">
                                        <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt-descuento" class="form-label text-primary">Descuento
                                                (%)</label>
                                            <input id="txt-descuento" name="txt-descuento" type="number"
                                                class="form-control form-control-sm" readonly>
                                        </div>

                                        <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt-documento_descuento"
                                                class="form-label text-primary">Documento de Descuento</label>
                                            <input id="txt-documento_descuento" name="txt-documento_descuento"
                                                type="file" class="form-control form-control-sm"
                                                accept=".pdf,.jpg,.png">
                                            <small id="doc-descuento-actual" class="form-text text-muted"></small>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado"
                                        class="default-select form-control form-control-sm" required>
                                        <option selected value="1">Pagado</option>
                                        <option value="2">Pendiente</option>
                                        <option value="0">No Pagado</option>
                                    </select>
                                </div>
                                <div id="div-txt-metodo_pago_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-metodo_pago_id" class="form-label text-primary">Método de
                                        Pago</label>
                                    <select id="txt-metodo_pago_id" name="txt-metodo_pago_id"
                                        class="default-select form-control form-control-sm" required>
                                    </select>
                                </div>
                                <div id="div-txt-banco_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-banco_id" class="form-label text-primary">Banco</label>
                                    <select id="txt-banco_id" name="txt-banco_id"
                                        class="default-select form-control form-control-sm" required>
                                    </select>
                                </div>
                                <div id="div-txt-nro_operacion" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nro_operacion" class="form-label text-primary">Número de
                                        Operación</label>
                                    <input id="txt-nro_operacion" name="txt-nro_operacion" type="number"
                                        class="form-control form-control-sm" placeholder="">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div id="div-txt-documento" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-documento" class="form-label text-primary">Boucher</label>
                                    <input id="txt-documento" name="txt-documento" type="file"
                                        class="form-control form-control-sm">
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3" style="display: none;">
                                    <label for="txt-resolucion" class="form-label text-primary">Resolución</label>
                                    <input id="txt-resolucion" name="txt-resolucion" type="file"
                                        class="form-control form-control-sm">
                                </div>
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-descripcion" class="form-label text-primary">Descripción</label>
                                    <textarea id="txt-descripcion" name="txt-descripcion" type="file"
                                        class="form-control form-control-sm" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>



    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/students.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/tesoreria/pagos.js']); ?>;

</body>

</html>
<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/registros_pagos/pagos/index.blade.php ENDPATH**/ ?>