<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Habilitar Cursos en un Periodo</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Habilitar Cursos en un Periodo
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- Column starts -->

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-warning pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodo Lectivo</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul id="tlsemester" class="timeline">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card border border-warning">
                                    <div
                                        class="card-header border-1 bg-warning pt-2 pb-2 justify-content-center">
                                        <h2 class="card-title text-light"><i class="fas fa-folder"></i> Info Per. Lectivo
                                        </h2>
                                    </div>
                                    <div class="card-body pb-0 pt-3">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Año - Número</strong>
                                                <span id="txt-anho_numero" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Fecha Inicio</strong>
                                                <span id="txt-fecinicio" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Fecha Fin</strong>
                                                <span id="txt-fecfin" class="mb-0">--</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 border-light bg-info pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul id="tlprogram" class="timeline">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="card border border-info">
                                    <div
                                        class="card-header border-1 border-light bg-info pt-2 pb-2 justify-content-center">
                                        <h2 class="card-title text-light"><i class="fas fa-map"></i> Info Programa
                                    </div>
                                    <div class="card-body pb-0 pt-3">
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Código</strong>
                                                <span id="txt-codprograma" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Nombre</strong>
                                                <span id="txt-nombre" class="mb-0">--</span>
                                            </li>
                                            <li class="list-group-item d-flex px-0 justify-content-between">
                                                <strong>Nivel Formativo</strong>
                                                <span id="txt-nivel_formativo" class="mb-0">--</span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Plan</th>
                                                                <th class="text-center">Semestre</th>
                                                                <th class="text-center">Ver U.D.</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Asociar</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idperiod" name="txt-idperiod">
    </form>




    <!-- Modal -->
    <form id="formModal2" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalDetalleCursos" class="modal fade" tabindex="-1" aria-labelledby="modalDetalleCursosLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalDetalleCursosLabel">Detalle Cursos</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                    </div>
                    <div class="modal-body pb-0">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card mb-0" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-1">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral2"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Código</th>
                                                                <th class="text-center">Nombre</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Créditos-Horas</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/timeline/programs.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/timeline/semesters.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/portafolio_cursos/semesterperiods.js']); ?>;

    
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/cursos/periodos_semestre/index.blade.php ENDPATH**/ ?>