<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Matricula y Prematrícula</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Matrículas y Prematrícula
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            
                            <!-- card -->
                            <div class="col-xl-3 col-lg-6 col-sm-6 col-12">
                                <div class="row">
                                    <div class="card p-0">
                                        <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                            <h2 class="card-title text-white">Periodo Lectivo</h2>
                                        </div>
                                        <div class="card-body p-0">
                                            <div id="DZ_W_TimeLine"
                                                class="widget-timeline dlab-scroll height350 my-2 px-2">
                                                <ul id="tlsemester" class="timeline">
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- column datatable -->
                            <div class="col-xl-9">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Ver cursos Matriculados por Periodo Lectivo</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Realizar Prematrícula
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Periodo</th>
                                                                <th class="text-center">Ud. Didáctica</th>
                                                                <th class="text-center">Seccion</th>
                                                                <th class="text-center">Turno</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Eliminar</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!-- Modal -->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <input type="hidden" id="txt-idsubjectenrollment" name="txt-idsubjectenrollment">
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idsubject" name="txt-idsubject">
    </form>


    <!-- Modal -->
    <form id="formModal2" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalCursos" class="modal fade" tabindex="-1" aria-labelledby="modalCursosLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCursosLabel">cursos disponibles para prematricularse en el periodo lectivo</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body pb-0">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card mb-0" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-1">
                                                <div class="row g-2 mb-2 align-items-end">
                                                    <div class="col-md-4">
                                                        <select id="txt-periods" name="txt-periods" class="form-control form-control-md">
                                                            <option value="" selected disabled>Seleccione un semestre</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral2"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Semestre</th>
                                                                <th class="text-center">Curso</th>
                                                                <th class="text-center">Seccion</th>
                                                                <th class="text-center">Turno</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Agregar</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/alumno/matricula.js']); ?>;
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/alumno/matricula/index.blade.php ENDPATH**/ ?>