<!DOCTYPE html>
<html lang="es">

<head>
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Docentes</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    
    <style>
        .btn-celeste {
            background-color: #00bcd4;
            /* Celeste */
            color: white;
        }

        .btn-celeste:hover {
            background-color: #0097a7;
            /* Color más oscuro al pasar el ratón */
        }

        .modal-dimmed {
            filter: blur(1px);
            transition: opacity 0.2s ease-in-out;
        }
    </style>
</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Gestionar Docentes
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************FFF
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="col-xl-12 col-xxl-12 col-lg-12">
                                <div class="card">
                                    <div class="card-body p-0">
                                        <div class="email-right-box">
                                            <div role="toolbar" class="toolbar  bg">
                                                <div class="saprat">
                                                    <div class="d-flex align-items-center">
                                                        <ul class="nav nav-pills  " id="pills-tab" role="tablist">
                                                            <li class="nav-item btn-group" role="presentation">
                                                                <button class="btn effect mx-2 nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="true">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512">
                                                                        <path d="M219.3 .5c3.1-.6 6.3-.6 9.4 0l200 40C439.9 42.7 448 52.6 448 64s-8.1 21.3-19.3 23.5L352 102.9V160c0 70.7-57.3 128-128 128s-128-57.3-128-128V102.9L48 93.3v65.1l15.7 78.4c.9 4.7-.3 9.6-3.3 13.3s-7.6 5.9-12.4 5.9H16c-4.8 0-9.3-2.1-12.4-5.9s-4.3-8.6-3.3-13.3L16 158.4V86.6C6.5 83.3 0 74.3 0 64C0 52.6 8.1 42.7 19.3 40.5l200-40zM111.9 327.7c10.5-3.4 21.8 .4 29.4 8.5l71 75.5c6.3 6.7 17 6.7 23.3 0l71-75.5c7.6-8.1 18.9-11.9 29.4-8.5C401 348.6 448 409.4 448 481.3c0 17-13.8 30.7-30.7 30.7H30.7C13.8 512 0 498.2 0 481.3c0-71.9 47-132.7 111.9-153.6z" />
                                                                    </svg>
                                                                    Docentes
                                                                </button>
                                                            </li>
                                                            <li class="nav-item btn-group" role="presentation" id="modulemasive">
                                                                <button class="btn  mx-2 effect nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="false">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 640 512">
                                                                        <path d="M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zm79-217c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39V392c0 13.3 10.7 24 24 24s24-10.7 24-24V257.9l39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80z" />
                                                                    </svg>
                                                                    Carga masiva
                                                                </button>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                    <div class="btn-group text-center mx-2">
                                                        <button type="button" id="btn_download_pantilla" data-toggle="tooltip" data-placement="top" title="Descargar plantilla de resgitro masiva" class="btn btn-success btn-sm">
                                                            <i class="fa-solid fa-file-excel"></i> 
                                                            Descargar Excel
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-content my-3" id="pills-tabContent">
                                                <div class="tab-pane fade  show active px-3 mt-3" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                                                    <div class="card-header flex-wrap px-3">
                                                        <div>
                                                            <h4 class="card-title">Registro de información sobre Docentes</h4>
                                                        </div>
                                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                                            + Nuevo Docente
                                                        </button>
                                                    </div>
                                                    <!-- /tab-content -->
                                                    <div class="tab-content" id="myTabContent-2">
                                                        <div class="tab-pane fade show active" id="withoutSpace"
                                                            Aulae="tabpanel" aria-labelledby="home-tab-2">
                                                            <div class="table-responsive">
                                                                <table id="datatableGeneral"
                                                                    class="table table-bordered table-sm display rounded-3"
                                                                    style="min-width:100%">
                                                                    <thead class="thead-primary">
                                                                        <tr>
                                                                            <th class="text-center">Tipo ID</th>
                                                                            <th class="text-center"># ID</th>
                                                                            <th class="text-center">Apellidos</th>
                                                                            <th class="text-center">Nombres</th>
                                                                            <th class="text-center">Tipo de Contrato</th>
                                                                            <th class="text-center">Acceso</th>
                                                                            <th class="text-center">Acciones</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody>
                                                                        <!--  -->
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                                    aria-labelledby="pills-profile-tab">
                                                    <div class="col-xl-12">
                                                        <div class="card" id="accordion-three">
                                                            <div class="card-header  m-0 px-3">
                                                                <div
                                                                    class="col-xl-5 col-md-6 col-sm-12 col-12 p-0 mt-2">
                                                                    <div class="input-group">
                                                                        <input class="form-control form-control-sm"
                                                                            id="file_select_plantilla"
                                                                            type="file" required>
                                                                        <div class="invalid-feedback">
                                                                            Ingrese un código.
                                                                        </div>
                                                                        <button class="btn btn-warning btn-sm"
                                                                            type="button" disabled
                                                                            id="btn_previsualizar_plantilla"><i
                                                                                class="fa-solid fa-magnifying-glass fa-beat-fade"></i>
                                                                            Previsualizar</button>
                                                                    </div>
                                                                </div>
                                                                <div
                                                                    class="col-xl-auto col-md-6 col-sm-12 col-12 mt-2 mx-2">
                                                                    <div
                                                                        class="row justify-content-center align-items-center">
                                                                        <button type="button"
                                                                            class="btn btn-primary btn-sm"
                                                                            id="btn_insert_plantilla"
                                                                            value="Registrar"><i
                                                                                class="fa-solid fa-upload fa-beat-fade"></i>
                                                                            Registrar
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- /tab-content -->
                                                            <div class="tab-content" id="myTabContent-2">
                                                                <div class="tab-pane fade show active"
                                                                    id="withoutSpace" role="tabpanel"
                                                                    aria-labelledby="home-tab-2">
                                                                    <div class="card-body px-3 p-4">
                                                                        <div class="table-responsive">
                                                                            <table
                                                                                id="datatableGeneral_preview_Excel"
                                                                                class="table table-hover table-bordered table-sm display rounded-3"
                                                                                style="min-width:100%">
                                                                                <thead class="thead-primary">
                                                                                    <tr>
                                                                                        <th class="text-center">Tipo doc.</th>
                                                                                        <th class="text-center">Nº doc.</th>
                                                                                        <th class="text-center">Password</th>
                                                                                        <th class="text-center">Nombres</th>
                                                                                        <th class="text-center">Apellido pa.</th>
                                                                                        <th class="text-center">Apellidos ma.</th>
                                                                                        <th class="text-center">Fecha nac.</th>
                                                                                        <th class="text-center">Tipo de Docente</th>
                                                                                        <th class="text-center">Tipo de Contrato</th>
                                                                                        <th class="text-center">Correo</th>
                                                                                        <th class="text-center">Teléfono</th>
                                                                                        <th class="text-center">Celular</th>
                                                                                        <th class="text-center">Dirección</th>
                                                                                        <th class="text-center">Género</th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                    <!--  -->
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!-- /tab-content -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form id="formModal" class="needs-validation" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nuevo Docente</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser" name="txt_iduser" type="hidden">
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-identificationtype" class="form-label text-primary">Tipo de
                                        ID</label>
                                    <select id="txt-identificationtype" name="txt-identificationtype"
                                        class="default-select  form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_nroidenti" class="form-label text-primary"># Identificación</label>
                                    <div class="input-group">
                                        <input id="txt_nroidenti" name="txt_nroidenti" type="number" autocomplete="off"
                                            class="form-control form-control-sm" placeholder="12345678" required>
                                        <a class="input-group-text bg-primary text-white btn btn-sm rounded-pill"
                                            href="javascript:void(0);" id="btn-querybd" data-bs-placement="top"
                                            title="Consultar usuario existente"> <i class="fa fa-search"></i> </a>
                                        <a class="input-group-text bg-info text-white btn btn-sm rounded-pill"
                                            href="javascript:void(0);" id="btn-querydata" data-bs-placement="top"
                                            title="Consultar RENIEC"> <i class="fa fa-search"></i> </a>
                                        <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                    </div>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_nombres" class="form-label text-primary">Nombres</label>
                                    <input id="txt_nombres" name="txt_nombres" type="text" autocomplete="off"
                                        class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese nombres" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_apellido_pa" class="form-label text-primary">Apellido
                                        paterno</label>
                                    <input id="txt_apellido_pa" name="txt_apellido_pa" type="text"
                                        autocomplete="off" class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese apellido paterno" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_apellido_ma" class="form-label text-primary">Apellido
                                        materno</label>
                                    <input id="txt_apellido_ma" name="txt_apellido_ma" type="text"
                                        autocomplete="off" class="form-control form-control-sm text-capitalize"
                                        placeholder="Ingrese apellido materno" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div id="div_txt_password" class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_password" class="form-label text-primary">Contraseña</label>
                                    <input id="txt_password" name="txt_password" type="password"
                                        class="form-control form-control-sm" placeholder="********" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_acceso" class="form-label text-primary">Acceso</label>
                                    <select id="txt_acceso" name="txt_acceso"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <?php echo $__env->make('include.combobox.bit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_fecnac" class="form-label text-primary">Fecha de
                                        Nacimiento</label>
                                    <input id="txt_fecnac" name="txt_fecnac" type="date"
                                        class="form-control form-control-sm" placeholder="" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-teachertypes" class="form-label text-primary">Tipo de
                                        docente</label>
                                    <select id="txt-teachertypes" name="txt-teachertypes"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_tipocontrato" class="form-label text-primary">Tipo de
                                        Contrato</label>
                                    <select id="txt_tipocontrato" name="txt_tipocontrato"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_estado" class="form-label text-primary">Estado</label>
                                    <select id="txt_estado" name="txt_estado"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="1">Contratado</option>
                                        <option value="0">Sin Contrato</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_correo" class="form-label text-primary">Correo Electrónico</label>
                                    <input id="txt_correo" name="txt_correo" type="email" autocomplete="off"
                                        class="form-control form-control-sm" placeholder="example@email.com" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_telefono" class="form-label text-primary">Teléfono</label>
                                    <input id="txt_telefono" name="txt_telefono" type="text" autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                        class="form-control form-control-sm" placeholder="357-2984">
                                    
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_celular" class="form-label text-primary">Celular</label>
                                    <input id="txt_celular" name="txt_celular" type="text" autocomplete="off"
                                        onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                        class="form-control form-control-sm" placeholder="967-542-321" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_genre_id" class="form-label text-primary">Género</label>
                                    <select id="txt_genre_id" name="txt_genre_id"
                                        class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <?php echo $__env->make('include.combobox.genre', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_departamento" class="form-label text-primary">Departamento</label>
                                    <select id="txt_departamento" name="txt_departamento"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                        <?php echo $__env->make('include.combobox.departamento', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_provincia" class="form-label text-primary">Provincia</label>
                                    <select id="txt_provincia" name="txt_provincia"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_distrito" class="form-label text-primary">Distrito</label>
                                    <select id="txt_distrito" name="txt_distrito"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox dinamico -->
                                        <option selected disabled value="">Seleccione opción</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_direccion" class="form-label text-primary">Dirección</label>
                                    <input id="txt_direccion" name="txt_direccion" type="text" autocomplete="off"
                                        class="form-control form-control-sm" maxlength="200"
                                        placeholder="Ejemplo: URB. SANTO DOMINGO ETAPA X MZ. M LT. 2" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form id="formModal2" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalUpdatePassword" class="modal fade" tabindex="-1" aria-labelledby="modalUpdatePasswordLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Contraseña</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser2" name="txt_iduser2" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_nroidenti2" class="form-label text-primary">#
                                        Identificación</label>
                                    <input id="txt_nroidenti2" name="txt_nroidenti2" type="text"
                                        autocomplete="off" class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_apenom" class="form-label text-primary">Apellidos y
                                        Nombres</label>
                                    <input id="txt_apenom" name="txt_apenom" type="text" autocomplete="off"
                                        class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_password2" class="form-label text-primary">Contraseña</label>
                                    <input id="txt_password2" name="txt_password2" type="password"
                                        autocomplete="off" class="form-control form-control-sm"
                                        placeholder="********">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdatePassword" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form id="formModal3" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalUpdateCredentialsZoom" class="modal fade" tabindex="-1"
            aria-labelledby="modalUpdateCredentialsZoomLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xs">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Credenciales de Zoom
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_iduser3" name="txt_iduser3" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_nroidenti3" class="form-label text-primary">#
                                        Identificación</label>
                                    <input id="txt_nroidenti3" name="txt_nroidenti3" type="text"
                                        autocomplete="off" class="form-control form-control-sm" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_account_id" class="form-label text-primary">ID de Cuenta
                                        (Zoom)</label>
                                    <input id="txt_account_id" name="txt_account_id" type="text"
                                        autocomplete="off" class="form-control form-control-sm"
                                        placeholder="Conseguir de API de Zoom">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_client_id" class="form-label text-primary">ID de Cliente
                                        (Zoom)</label>
                                    <input id="txt_client_id" name="txt_client_id" type="text" autocomplete="off"
                                        class="form-control form-control-sm" placeholder="Conseguir de API de Zoom">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt_client_secret" class="form-label text-primary">Client Secret
                                        (Zoom)</label>
                                    <input id="txt_client_secret" name="txt_client_secret" type="text"
                                        autocomplete="off" class="form-control form-control-sm"
                                        placeholder="Conseguir de API de Zoom">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdateCredentialsZoom" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form id="formModal5" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalView_cnl" class="modal fade bd-example-modal-xl" tabindex="-1" role="dialog"
            aria-hidden="true">
            <div class="modal-dialog modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5">Detalle Actividades no Lectivas
                        </h1>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="text_hidden_iddocente_f15" name="text_hidden_iddocente_f15">
                        <div class="table-responsive">
                            <table class="table table-bordered table-responsive-sm">
                                <thead>
                                    <tr>
                                        <th class="text-center"><strong>TOTAL DE HORAS NL</strong></th>
                                        <th class="text-center"><strong>HORAS CARGADAS</strong></th>
                                        <th class="text-center"><strong>HORAS RESTANTES</strong></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center" id="dato_totalhnl_f15"></td>
                                        <td class="text-center" id="total_hcargadas_f15"></td>
                                        <td class="text-center" id="total_hrestantes_f15"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-responsive-sm" id="tabla_detalleActividadesNl">
                                <thead>
                                    <tr>
                                        <th colspan="2" class="text-center"><strong>ACTIVIDADES <br> NO LECTIVAS</strong></th>
                                        <th class="text-center"><strong>DISTRIBUCION <br> DE CARGA <br>HORARIA</strong></th>
                                        <th class="text-center"><strong>DESCRIPCION <br> DEL DESARROLLO</strong></th>
                                        <th colspan="2" class="text-center"><strong>DÍA</strong></th>
                                        <th class="text-center"><strong>HORARIO</strong></th>
                                        <th class="text-center"><strong>TOTAL <br> DE HORAS</strong></th>
                                    </tr>
                                </thead>
                                <tbody id="tabla-actividades">
                                    <!-- Aquí se insertarán las filas dinámicamente -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <form id="formModal4" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalGestion_cnl" class="modal fade" tabindex="-1" aria-labelledby="modalGestion_cnlLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Gestionar Actividades no Lectivas
                        </h1>
                        <div class="d-flex">
                            <button id="btn_addHorario" type="button" class="btn btn-warning btn-sm">
                                + Horario
                            </button>
                        </div>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="text_hidden_iddocente" name="text_hidden_iddocente">
                        <input type="hidden" id="text_hidden_idactividad_cnl" name="text_hidden_idactividad_cnl">
                        <div class="row">
                            <div class="table-responsive" id="tabla_primera">
                                <table class="table table-bordered table-responsive-sm">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><strong>TOTAL DE HORAS NL</strong></th>
                                            <th class="text-center"><strong>HORAS CARGADAS</strong></th>
                                            <th class="text-center"><strong>HORAS RESTANTES</strong></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="text-center" id="dato_totalhnl"></td>
                                            <td class="text-center" id="total_hcargadas"></td>
                                            <td class="text-center" id="total_hrestantes"></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="d-flex col-xl-12">
                                <!-- data -->
                                <div class="col-xl-8 col-md-8 col-sm-8 col-8 mb-3 pe-3">
                                    <label for="txt_actividad_nl" class="form-label text-primary">Actividad No
                                        Lectiva</label>
                                    <input id="txt_actividad_nl" name="txt_actividad_nl" type="text"
                                        autocomplete="off" class="form-control form-control-sm" required>
                                </div>
                                <div class="col-xl-4 col-md-4 col-sm-4 col-4 mb-3">
                                    <label for="txt_timepo_nl" class="form-label text-primary">Tiempo</label>
                                    <input id="txt_timepo_nl" name="txt_timepo_nl" type="time" autocomplete="off" onkeypress='return event.charCode >= 48 && event.charCode <= 57' maxlength="3"
                                        class="form-control form-control-sm" required>
                                </div>
                            </div>
                            <div class="col-xl-12 col-md-12 col-sm-12 card schedule-card bg-info-light">
                                <label for="dt-comentario" class="form-label text-primary">
                                    <h5>Descripcion:</h5>
                                </label>
                                <textarea name="text_descripcion" id="text_descripcion" rows="5" class="form-control"
                                    placeholder="Ingrese cada punto en una nueva línea" required></textarea>
                            </div>
                            <div id="section_Horario" class="col-xl-12 col-md-12 col-sm-12 card schedule-card bg-info-light">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdateActividad_nl" type="button" value="Create"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- MODAL: DOCUMENTOS REQUERIDOS DEL DOCENTE -->
    <div class="modal fade" id="modalRequiredDocsTeacher" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <div>
                        <h5 class="modal-title mb-0">Documentos requeridos del docente</h5>
                        <span class="text-muted d-block">
                            <span id="docRequiredTeacherName"></span> | DNI: <span id="docRequiredTeacherDni"></span>
                        </span>
                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">

                    <div class="table-responsive">
                        <table id="datatableDocsTeacher" class="table table-bordered table-sm display rounded-3" style="min-width:100%">
                            <thead class="thead-primary">
                                <tr>
                                    <th class="text-center">#</th>
                                    <th class="text-center">Requisito</th>
                                    <th class="text-center">Revisado por</th>
                                    <th class="text-center">Documento</th>
                                    <th class="text-center">Estado</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- se llena por DataTables -->
                            </tbody>
                        </table>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger btn-sm light" data-bs-dismiss="modal">
                        Cerrar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal: FOMULARIO - DOCUMENTOS REQUERIDOS DEL DOCENTE -->
    <form class="needs-validation" id="formModalDocuments">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdateDocument" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateDocumentLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateDocumentLabel">Registrar Nuevo Documento de Docente</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-id" name="txt-id" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado"
                                        class="default-select form-control form-control-sm" required>
                                        <option value="0" selected>Pendiente</option>
                                        <option value="1">Aprobado</option>
                                        <option value="2">Rechazado</option>
                                    </select>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdateDocument" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <div id="modalCargandoExcel" class="modal fade" tabindex="-1" aria-labelledby="modalCargandoExcel"
        aria-hidden="true" style="background: rgba(0,0,123,0.4)">
        <div class="modal-dialog modal-dialog-center modal-xl">
            <div class="modal-content">
                <!-- body -->
                <div class="modal-body">
                    <div class="row">
                        <input type="hidden" value="0" id="hiddenswitch">
                        <div class="col-xl-12 text-primary mx-2">
                            <h1 class="modal-title fs-5" id="id_preload_excel"></h1>
                        </div>
                        <div class="col-xl-12" id="div_progressbar_modal_preload">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/docentes/docentes.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/docentes/plantilla.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/teachercontracttypes.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/teachertypes.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/identificationtypes.js']); ?>;

    <script>
        const textarea = document.getElementById('text_descripcion');

        textarea.addEventListener('keydown', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault(); // Evita que el Enter añada un salto de línea predeterminado
                const start = this.selectionStart;
                const end = this.selectionEnd;

                // Inserta un bullet point y un salto de línea
                const value = this.value;
                this.value = value.substring(0, start) + '\n● ' + value.substring(end);

                // Coloca el cursor al final de la nueva línea
                this.selectionStart = this.selectionEnd = start + 3; // 3 porque "\n● " son 3 caracteres
            }
        });

        // Agrega el primer bullet point automáticamente al cargar la página
        textarea.addEventListener('focus', function() {
            if (!this.value.trim()) {
                this.value = '● ';
                this.selectionStart = this.selectionEnd = this.value.length;
            }
        });

        // Función para calcular la diferencia entre dos horas
        function calcularDuracion(horaInicio, horaFin) {
            if (!horaInicio || !horaFin) return '';

            // Convertir a objetos Date para cálculos
            const [inicioHoras, inicioMinutos] = horaInicio.split(':').map(Number);
            const [finHoras, finMinutos] = horaFin.split(':').map(Number);

            const inicio = new Date(0, 0, 0, inicioHoras, inicioMinutos);
            const fin = new Date(0, 0, 0, finHoras, finMinutos);

            // Calcular la diferencia en milisegundos
            let diferencia = fin - inicio;

            // Manejar casos donde la hora de fin es el día siguiente
            if (diferencia < 0) {
                diferencia += 24 * 60 * 60 * 1000;
            }

            // Convertir la diferencia a horas y minutos
            const horas = Math.floor(diferencia / (1000 * 60 * 60));
            const minutos = Math.floor((diferencia % (1000 * 60 * 60)) / (1000 * 60));

            return `${horas}:${minutos.toString().padStart(2, '0')}`; // Formato hh:mm
        }

        // Evento para calcular la duración cuando se cambia hora inicio o fin
        document.addEventListener('input', (e) => {
            if (e.target.classList.contains('hora-inicio') || e.target.classList.contains('hora-fin')) {
                const row = e.target.closest('.row');
                const horaInicio = row.querySelector('.hora-inicio').value;
                const horaFin = row.querySelector('.hora-fin').value;
                const duracionField = row.querySelector('.duracion');

                // Calcular y mostrar la duración
                duracionField.value = calcularDuracion(horaInicio, horaFin);
            }
        });
    </script>
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/docentes/gestionar/index.blade.php ENDPATH**/ ?>