<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Historial de Postulaciones</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Historial de Postulaciones
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Empresa</th>
                                                                <th class="text-center">Puesto</th>
                                                                <th class="text-center">Rango salarial</th>
                                                                <th class="text-center">Fecha Postulación</th>
                                                                <th class="text-center">Ver CV</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Link</th>
                                                                <th class="text-center">Datos Externos</th>
                                                                <th class="text-center">Comentario</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!-- Modal -->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalDescripcion" class="modal fade" tabindex="-1" aria-labelledby="modalDescripcionLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalDescripcionLabel">Datos Externos</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3" style="display: none;">
                                    <textarea id="txt-descripcion" name="txt-descripcion"
                                        class="form-control form-control-sm" placeholder="Ingrese descripción">
                                    </textarea>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <div id="txt-descripcion2" name="txt-descripcion2"
                                        >
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- footer -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

        <!-- Modal -->
        <form id="formModal2" novalidate>
            <?php echo csrf_field(); ?>
            <div id="modalComentario" class="modal fade" tabindex="-1" aria-labelledby="modalComentarioLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-center modal-ls">
                    <div class="modal-content">
                        <!-- header -->
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="modalComentarioLabel">Comentarios</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <!-- body -->
                        <div class="modal-body">
                            <div class="row">
                                <div class="row col-xl-12">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3" style="display: none;">
                                        <input id="txt-fecfeedback" name="txt-fecfeedback" type="text"
                                            class="form-control form-control-sm" placeholder="Ingrese descripción">
                                    </div>
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <textarea id="txt-feedback" name="txt-feedback" class="form-control form-control-sm" readonly>
                                        </textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- footer -->
                        <div class="modal-footer">
                            <button type="button" class="btn btn-danger  btn-sm light"
                                data-bs-dismiss="modal">Cerrar</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>
    <script>
        tinymce.init({
            selector: '#txt-descripcion',
        });
    </script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;


    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/alumno/postulaciones.js']); ?>;

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/alumno/postulaciones/index.blade.php ENDPATH**/ ?>