<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Panel</title>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">

    <style>
        /* Cambia el color del texto del menú de ApexCharts */
        .apexcharts-menu-item {
            color: #000 !important;
            /* negro */
        }

        /* (Opcional) cambia el color de fondo del menú si lo deseas */
        .apexcharts-menu {
            background-color: #fff !important;
            /* blanco */
            border: 1px solid #ddd !important;
        }

        /* (Opcional) cambia el hover */
        .apexcharts-menu-item:hover {
            background-color: #f1f1f1 !important;
        }
    </style>

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->

    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        
        <?php $__env->startSection('titlenavbar'); ?>
            <?php echo e(__('Panel')); ?>

        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <form id="form">
            <?php echo csrf_field(); ?>
            <input type="hidden" id="op" name="op" value="1">
            <div class="content-body">
                <div class="container-fluid">
                    <div class="row">

                        
                        <?php echo $__env->make('home.adm.dashboard.stats', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Recaudación por Meses</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="recaudacion_meses"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Recaudación por Conceptos</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="recaudacion_conceptos"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Estudiantes por Programas</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="estudiantes_programas"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-lg-12">
                            <div class="card">
                                <div class="card-header border-1 p-static pb-2">
                                    <div>
                                        <h4 class="card-title">Egresados por Año</h4>
                                    </div>
                                </div>
                                <div class="card-body tab-content p-3 py-0">
                                    <div class="tab-pane fade show active" id="monthly">
                                        <div id="egresados_anho"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        

                    </div>
                </div>
            </div>
        </form>

        <!--**********************************
            Content body end
        ***********************************-->

        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>


    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->make('include.modal-versiones', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Dashboard -->
    <script src="<?php echo e(asset('/vendor/chart.js/Chart.bundle.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('/vendor/apexchart/apexchart.js')); ?>"></script>
    <script src="<?php echo e(asset('/vendor/wow-master/dist/wow.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dashboard/dashboard-2.js')); ?>"></script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/dashboard/main.js']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/dashboard/recaudacion-meses.js']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/dashboard/recaudacion-conceptos.js']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/dashboard/estudiantes-programas.js']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/dashboard/egresados-anho.js']); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/home/adm/dashboard.blade.php ENDPATH**/ ?>