<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Admisiones</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    
    <style>
        #toast-container {
            position: fixed;
            bottom: 10px;
            right: 10px;
            z-index: 9999;
        }

        .toast {
            background-color: #444;
            color: white;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 5px;
            opacity: 0.9;
            transition: opacity 0.5s ease-in-out;
        }

        .toast-error {
            background-color: red;
        }

        .toast-success {
            background-color: green;
        }

        .btn-purple {
            background-color: #800080;
            /* Morado */
            border-color: #800080;
        }

        .btn-purple:hover {
            background-color: #9b4d99;
            /* Un tono más claro para hover */
            border-color: #9b4d99;
        }
    </style>

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Gestionar Admisiones
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Procesos de Admisión</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Admisión
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" Aulae="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Admisión</th>
                                                                <th class="text-center">Acciones</th>
                                                                <th class="text-center">Programa</th>
                                                                <th class="text-center">Vacantes</th>
                                                                <th class="text-center">Pje Mínimo</th>
                                                                <th class="text-center">Programa</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Crear nuevo Proceso de Admisión</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idadmission" name="txt-idadmission" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-anho" class="form-label text-primary">Año</label>
                                    <input id="txt-anho" name="txt-anho" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: 2024" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecinicio" class="form-label text-primary">Fecha Inicio</label>
                                    <input id="txt-fecinicio" name="txt-fecinicio" type="date"
                                        class="form-control form-control-sm" placeholder="" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecfin" class="form-label text-primary">Fecha Fin de
                                        Admisión</label>
                                    <input id="txt-fecfin" name="txt-fecfin" type="date"
                                        class="form-control form-control-sm" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecfin_postulacion" class="form-label text-primary">Fecha Límite de
                                        Registro de Postulaciones</label>
                                    <input id="txt-fecfin_postulacion" name="txt-fecfin_postulacion" type="date"
                                        class="form-control form-control-sm" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-informacion" class="form-label text-primary">Información del
                                        proceso</label>
                                    <textarea id="txt-informacion" name="txt-informacion" class="form-control form-control-sm"
                                        placeholder="Ingrese descripción">
                                    </textarea>
                                </div>
                                <!-- data -->
                                
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form class="needs-validation" id="formModal2">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdateAdmissionplan" class="modal fade" tabindex="-1"
            aria-labelledby="modalCreateUpdateAdmissionplanLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateAdmissionplanLabel">Añadir programa a la
                            admisión</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idadmissionplan" name="txt-idadmissionplan" type="hidden">
                                <!-- data -->
                                <div id="div-txt-programs" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-programs" class="form-label text-primary">Programa</label>
                                    <select id="txt-programs" name="txt-programs"
                                        class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione programa</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-plans" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-plans" class="form-label text-primary">Plan</label>
                                    <select id="txt-plans" name="txt-plans"
                                        class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione plan</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-vacantes_ordinario" class="form-label text-primary">Vacantes
                                        Ordinario</label>
                                    <input id="txt-vacantes_ordinario" name="txt-vacantes_ordinario" type="number"
                                        class="form-control form-control-sm" placeholder="Ejm: 100" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-vacantes_exoneracion" class="form-label text-primary">Vacantes
                                        Exoneración</label>
                                    <input id="txt-vacantes_exoneracion" name="txt-vacantes_exoneracion"
                                        type="number" class="form-control form-control-sm" placeholder="Ejm: 50"
                                        required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-puntaje_minimo" class="form-label text-primary">Puntaje
                                        Mínimo</label>
                                    <input id="txt-puntaje_minimo" name="txt-puntaje_minimo" type="number"
                                        class="form-control form-control-sm">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdateAdmissionplan" type="button"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form id="formModalEstadisticas" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalEstadisticas" class="modal fade" tabindex="-1" aria-labelledby="modalEstadisticasLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg"> <!-- Cambiado de modal-lg a modal-xl -->
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalEstadisticasLabel">Estadísticas</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body pb-0">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card mb-0" id="accordion-three">
                                    <!-- data -->
                                    <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                        <select id="txt-tipo" name="txt-tipo"
                                            class="default-select form-control form-control-md" required>
                                            <option selected disabled value="">Seleccione una opción</option>
                                            <option value="genero">Estadísticas por Género</option>
                                            <option value="edad">Estadísticas por Edad</option>
                                            <option value="ubicacion">Estadísticas por Ubicación</option>
                                        </select>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-1">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral2"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Dato</th>
                                                                <th class="text-center">Cantidad</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal Information -->
    <div id="modalInformation" class="modal fade" tabindex="-1" aria-labelledby="modalInformationLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="modalInformationLabel">Información del Proceso de Admisión</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div id="infoLoader" class="d-flex justify-content-center align-items-center" style="height: 200px;">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                    <div id="infoContent" class="d-none">
                        <p id="infoText">No hay información disponible.</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <div id="toast-container"></div>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';

        tinymce.init({
            selector: '#txt-informacion',
            setup: function (editor) {
                editor.on('change', function () {
                    editor.save();
                });
            }
        });

        // Validar el formulario antes de enviar
        document.getElementById('btnCreateUpdate').addEventListener('click', function(event) {
            let form = document.getElementById('formModal');
            if (!form.checkValidity() || tinymce.get("txt-informacion").getContent() === "") {
                event.preventDefault();
                event.stopPropagation();
                showToast('error', 'Por favor, complete todos los campos requeridos.');
            } else {
                showToast('success', 'Formulario enviado correctamente.');
            }
            form.classList.add('was-validated');
        });

        // Mostrar información en el modal
        $("#datatableGeneral tbody").on("click", ".modalInformation", function (e) {
            let idadmission = $(this).data("idadmission");
            $("#infoLoader").removeClass("d-none");
            $("#infoContent").addClass("d-none");
            $("#infoText").html("No hay información disponible.");
            $("#modalInformation").modal("show");

            $.ajax({
                url: `/admin/admision/admisiones/informacion/${idadmission}`,
                type: 'GET',
                success: function (response) {
                    if (response.status) {
                        $("#infoText").html(response.informacion || "No hay información disponible.");
                    } else {
                        $("#infoText").html("No hay información disponible.");
                    }
                    $("#infoLoader").addClass("d-none");
                    $("#infoContent").removeClass("d-none");
                },
                error: function () {
                    $("#infoText").html("Error al cargar la información.");
                    $("#infoLoader").addClass("d-none");
                    $("#infoContent").removeClass("d-none");
                }
            });
        });

    </script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/admision/admisiones.js']); ?>;

    
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/admision/admisiones/index.blade.php ENDPATH**/ ?>