<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Convalidaciones</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Convalidaciones externas
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="col-xl-6 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul id="tlprogram" class="timeline">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-6 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Estudiantes</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <!--  -->
                                        <div class="my-2 px-2">
                                            <select id="txt-student" class="form-control selectpicker" data-size="5"
                                                data-show-subtext="true" data-live-search="true" required>
                                                <option disabled selected value="0">Buscar Estudiante</option>
                                            </select>
                                        </div>
                                        <div class="my-1 px-3">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item d-flex px-0 justify-content-between">
                                                    <strong>Nombres</strong>
                                                    <span id="txt-info-nombres" class="mb-0">--</span>
                                                </li>
                                                <li class="list-group-item d-flex px-0 justify-content-between">
                                                    <strong>DNI</strong>
                                                    <span id="txt-info-id" class="mb-0">--</span>
                                                </li>
                                                <li class="list-group-item d-flex px-0 justify-content-between">
                                                    <strong>Año Ingreso</strong>
                                                    <span id="txt-info-anho_ingreso" class="mb-0">--</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- header -->
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de convalidaciones por Estudiante</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm">
                                            + Nueva Convalidación para el Estudiante
                                        </button>
                                    </div>
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Institución</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Fecha registro</th>
                                                                <th class="text-center">Documento</th>
                                                                <th class="text-center">Cursos</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!-- Modal -->
    <!-- Modal: Nueva Convalidación Externa -->
    <div class="modal fade" id="modalNuevaConvalidacion" tabindex="-1" aria-labelledby="modalNuevaConvalidacionLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
            <div class="modal-content shadow-lg border-0">
                <div class="modal-header bg-gradient-primary text-white py-2 px-3">
                    <h5 class="modal-title d-flex align-items-center gap-2" id="modalNuevaConvalidacionLabel">
                        <i class="fas fa-file-signature"></i> Nueva convalidación externa
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>

                <form id="formNuevaConvalidacion" class="needs-validation" novalidate enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="student_id" id="student_id">

                    <div class="modal-body p-3">
                        <div class="row g-3">
                            <!-- FECHA -->
                            <div class="col-md-6">
                                <label class="form-label fw-semibold" for="fecha_registro">Fecha de registro <span
                                        class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-calendar-day"></i></span>
                                    <input type="date" class="form-control" id="fecha_registro"
                                        name="fecha_registro" required>
                                </div>
                                <div class="form-text">Fecha en que se realizó la convalidación.</div>
                                <div class="invalid-feedback">Seleccione una fecha.</div>
                            </div>

                            <!-- DOCUMENTO -->
                            <div class="col-md-8">
                                <label class="form-label fw-semibold" for="documento">Documento de respaldo</label>
                                <input id="documento" name="documento" type="file" class="form-control"
                                    accept=".pdf,.doc,.docx,.jpg,.jpeg,.png">
                                <div class="form-text">Formatos: PDF, DOC/DOCX, JPG/PNG. Máx. 5 MB.</div>
                                <div class="invalid-feedback">Archivo no válido o muy pesado.</div>
                            </div>

                            <!-- PREVIEW -->
                            <div class="col-md-4">
                                <div id="previewCard" class="card h-100 d-none border-0 shadow-sm">
                                    <div class="card-body py-3">
                                        <div class="d-flex align-items-center gap-2">
                                            <i class="fas fa-paperclip fa-lg text-primary"></i>
                                            <div class="small">
                                                <div id="previewName" class="fw-semibold text-truncate"></div>
                                                <div id="previewSize" class="text-muted"></div>
                                            </div>
                                        </div>
                                        <a id="previewLink" href="#" target="_blank"
                                            class="btn btn-outline-primary btn-sm mt-2 d-none">
                                            Ver archivo
                                        </a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="modal-footer bg-light">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times"></i> Cancelar
                        </button>
                        <button id="btnGuardarConvalidacion" type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <!-- Modal para visualizar documento -->
    <div class="modal fade" id="modalViewDocument" tabindex="-1" aria-labelledby="modalViewDocumentLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content shadow-lg border-0">
                <div class="modal-header bg-gradient-primary text-white py-2 px-3">
                    <h5 class="modal-title d-flex align-items-center gap-2" id="modalViewDocumentLabel">
                        <i class="fas fa-file-alt"></i>
                        <span id="documentTitle">Visualizar Documento</span>
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Cerrar"></button>
                </div>
                <div class="modal-body p-0">
                    <div class="container-fluid p-0">
                        <!-- Alert para tipos no soportados -->
                        <div id="unsupportedAlert" class="alert alert-warning m-3 d-none">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span id="unsupportedMessage">Este tipo de archivo no puede visualizarse en el
                                navegador.</span>
                        </div>

                        <!-- Contenedor del visor -->
                        <div id="documentViewer" class="d-none">
                            <!-- PDF Viewer -->
                            <div id="pdfViewer" class="d-none w-100">
                                <iframe id="pdfFrame" src="" class="w-100"
                                    style="height: 70vh; border: none;" frameborder="0">
                                </iframe>
                            </div>

                            <!-- Image Viewer -->
                            <div id="imageViewer" class="d-none text-center">
                                <img id="imageFrame" src="" class="img-fluid" style="max-height: 70vh;"
                                    alt="Documento visualizado">
                            </div>

                            <!-- Text Viewer (para documentos de texto simples) -->
                            <div id="textViewer" class="d-none p-3">
                                <pre id="textContent" class="bg-light p-3 rounded" style="max-height: 70vh; overflow-y: auto;"></pre>
                            </div>
                        </div>

                        <!-- Información del documento -->
                        <div class="card border-0 bg-light m-3">
                            <div class="card-body py-2">
                                <div class="row">
                                    <div class="col-md-8">
                                        <small class="text-muted">
                                            <i class="fas fa-file me-1"></i>
                                            <strong id="fileNameInfo">-</strong>
                                        </small>
                                    </div>
                                    <div class="col-md-4 text-end">
                                        <a id="downloadLink" href="#" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-download me-1"></i>Descargar
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times"></i> Cerrar
                    </button>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal Agregar Curso -->
    <div class="modal fade" id="modalAddCourse" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered"> <!-- xl para tener dos columnas cómodas -->
            <div class="modal-content" autocomplete="off">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="convalidacion_externa_id" id="convalidacion_externa_id">

                <div class="modal-header bg-gradient-primary text-white">
                    <h5 class="modal-title">Registro de equivalencia de curso</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">
                        <!-- IZQUIERDA: Tabla -->
                        <div class="col-lg-8 left-col">
                            <div class="card h-100">
                                <div class="card-header py-2">
                                    <strong>Lista de cursos</strong>
                                </div>
                                <div class="card-body p-2">
                                    <div class="table-responsive">
                                        <table id="datatableEquivalences"
                                            class="table table-sm table-hover table-bordered align-middle w-100">
                                            <thead class="table-light">
                                                <tr>
                                                    <th class="text-center">Código</th>
                                                    <th class="text-center">Curso</th>
                                                    <th class="text-center">Créditos</th>
                                                    <th class="text-center">Horas</th>
                                                    <th class="text-center">Nota</th>
                                                    <th class="text-center">Observaciones</th>
                                                    <th class="text-center">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- DERECHA: Formulario -->
                        <div class="col-lg-4 right-col">
                            <form id="formAddCourse" class="card h-10 needs-validation compact-form" novalidate>
                                <?php echo csrf_field(); ?>
                                <div class="card-header py-2">
                                    <strong>Registro de curso</strong>
                                </div>
                                <div class="card-body">
                                    <input type="hidden" name="convalidation_id" id="convalidation_id">

                                    <div class="mb-2">
                                        <label class="form-label">Curso del plan <span
                                                class="text-danger">*</span></label>
                                        <select name="course_id" id="cbCursosPlan" class="form-control selectpicker"
                                            data-live-search="true" required>
                                            <option value="">-- Seleccione --</option>
                                        </select>
                                        <div class="invalid-feedback">Seleccione un curso del plan.</div>
                                    </div>

                                    <div class="mb-2">
                                        <label class="form-label">Código curso externo <span
                                                class="text-danger">*</span></label>
                                        <input type="text" name="code" class="form-control" maxlength="50"
                                            required>
                                        <div class="invalid-feedback">Ingrese el código del curso externo.</div>
                                    </div>

                                    <div class="mb-2">
                                        <label class="form-label">Nombre del curso externo <span
                                                class="text-danger">*</span></label>
                                        <input type="text" name="name" class="form-control" maxlength="255"
                                            required>
                                        <div class="invalid-feedback">Ingrese el nombre del curso externo.</div>
                                    </div>

                                    <div class="row">
                                        <div class="col-6 mb-2">
                                            <label class="form-label">Créditos <span
                                                    class="text-danger">*</span></label>
                                            <input type="number" name="creditos" class="form-control" min="1"
                                                max="99" required>
                                            <div class="invalid-feedback">Ingrese créditos válidos.</div>
                                        </div>
                                        <div class="col-6 mb-2">
                                            <label class="form-label">Horas lectivas<span
                                                    class="text-danger">*</span></label>
                                            <input type="number" name="horas_por_semana" class="form-control"
                                                min="1" max="40" required>
                                            <div class="invalid-feedback">Ingrese horas válidas.</div>
                                        </div>
                                    </div>

                                    <div class="mb-2">
                                        <label class="form-label">Nota promedio</label>
                                        <input type="number" step="0.1" name="final_average"
                                            class="form-control" min="0" max="20">
                                    </div>

                                    <div class="mb-2">
                                        <label class="form-label">Observación</label>
                                        <textarea name="observation" class="form-control" rows="2" maxlength="500"></textarea>
                                    </div>
                                </div>
                                <div class="card-footer bg-light d-flex justify-content-end gap-2">
                                    <button type="button" class="btn btn-outline-secondary"
                                        data-bs-dismiss="modal">Cerrar</button>
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>



    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/estudiantes/convalidaciones.js']); ?>;

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/estudiantes/convalidaciones/index.blade.php ENDPATH**/ ?>