<!DOCTYPE html>
<html lang="es">

<head>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <title>Información Institucional</title>
    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!--**********************************
        Main wrapper start
    ***********************************-->

    <div id="main-wrapper">
        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Información Institucional
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
        Content body start
    ***********************************-->
        <div class="content-body">
            <div class="container-fluid">

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Información institucional</h4>
                            </div>

                            <div class="card-body">
                                <form id="formInfo" class="needs-validation" novalidate>
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="mb-3">
                                        <label class="form-label">Nombre</label>
                                        <input type="text" id="nombre" name="nombre" class="form-control"
                                            required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Logo</label>
                                        <div class="input-group">
                                            <input type="file" id="logoFile" accept="image/*" class="form-control">
                                        </div>
                                        <img id="logoPreview" class="img-fluid mt-2 d-none" style="max-height:120px">
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Dirección</label>
                                        <input type="text" id="direccion" name="direccion" class="form-control"
                                            required>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Contacto</label>
                                        <input type="text" id="contacto" name="contacto" class="form-control"
                                            required>
                                    </div>

                                    <div class="d-flex justify-content-end gap-2">
                                        <button type="button" id="btnGuardarInfo"
                                            class="btn btn-primary btn-sm">Guardar
                                            cambios</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <?php $__env->startPush('scripts'); ?>
                    <script>
                        function previewLogo(e) {
                            const file = e.target.files[0];
                            if (file) {
                                const reader = new FileReader();
                                reader.onload = function(ev) {
                                    const img = document.getElementById('logoPreview');
                                    img.src = ev.target.result;
                                    img.classList.remove('d-none');
                                };
                                reader.readAsDataURL(file);
                            }
                        }
                    </script>
                <?php $__env->stopPush(); ?>
            </div>
        </div>
        <!--**********************************
        Content body end
    ***********************************-->

        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->
    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/institucion/info_instita.js']); ?>
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/institucion/info_institucional/index.blade.php ENDPATH**/ ?>