<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Sedes</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
        Gestionar Sedes
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Sedes</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Sede
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Codigo</th>
                                                                <th class="text-center">Nombre</th>
                                                                <th class="text-center">Tipo de Sede</th>
                                                                <th class="text-center">Direccion</th>
                                                                <th class="text-center">Telefono</th>
                                                                <th class="text-center">Correo</th>
                                                                <th class="text-center">Horas de Servicio</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva Sede</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">
                        <div class="row">
                            <input id="txt-id" name="txt-id" type="hidden">

                            <!-- columna izquierda -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="txt-tipo_sede" class="form-label text-primary">Tipo de Sede</label>
                                    <select id="txt-tipo_sede" name="txt-tipo_sede"
                                        class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="Central">Central</option>
                                        <option value="Anexo">Anexo</option>
                                        <option value="Filial">Filial</option>
                                        <option value="Otros">Otros</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="txt-codigo" class="form-label text-primary">Codigo</label>
                                    <input id="txt-codigo" name="txt-codigo" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: Ejemplo" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="txt-nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-nombre" name="txt-nombre" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: Ejemplo" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="txt-nombre_corto" class="form-label text-primary">Nombre Corto</label>
                                    <input id="txt-nombre_corto" name="txt-nombre_corto" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: Ejemplo" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="txt-direccion" class="form-label text-primary">Direccion</label>
                                    <input id="txt-direccion" name="txt-direccion" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: Ejemplo" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>

                            <!-- columna derecha -->
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="txt-telefono" class="form-label text-primary">Telefono</label>
                                    <input id="txt-telefono" name="txt-telefono" type="number"
                                        class="form-control form-control-sm" placeholder="Ejm: 999888777" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="txt-correo" class="form-label text-primary">Correo</label>
                                    <input id="txt-correo" name="txt-correo" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: sede-ejemplo@gmail.com"
                                        required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="txt-nombre_representante" class="form-label text-primary">Nombre
                                        Representante</label>
                                    <input id="txt-nombre_representante" name="txt-nombre_representante" type="text"
                                        class="form-control form-control-sm" placeholder="Ejm: Representante Ejemplo"
                                        required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="mb-3">
                                    <label for="txt-horas_servicio" class="form-label text-primary">Horas de
                                        Servicio</label>
                                    <input id="txt-horas_servicio" name="txt-horas_servicio" type="text"
                                        class="form-control form-control-sm"
                                        placeholder="Ejm: Lunes a Viernes de 8:00 - 18:00" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>




    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/institucion/sedes.js']); ?>

</body>

</html>
<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/institucion/sedes/index.blade.php ENDPATH**/ ?>