<!DOCTYPE html>
<html lang="es">

<head>
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <!-- Page Title Here -->
    <title>Estudiantes por Periodo</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Matricular Estudiantes en Periodos Lectivos
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12 p-0">                       
                        <div class="row col-xl-12 m-0">
                            <!-- FILTRO -->
                            <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                <label for="txt-programs" class="form-label text-primary"><b><h4>Programa</h4></b></label>
                                <select id="txt-programs" name="txt-programs" class="form-control form-control-md"
                                    data-live-search="true" required>
                                    <!-- combobox -->
                                </select>
                            </div>
                            <!-- FILTRO -->
                            <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                <label for="txt-plans" class="form-label text-primary"><b><h4>Plan</h4></b></label>
                                <select id="txt-plans" name="txt-plans"
                                    class="form-control form-control-md" data-live-search="true" required>
                                    <option selected disabled value="">Seleccione un plan</option>
                                    <!-- combobox -->
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Periodo</th>
                                                                <th class="text-center">Estudiante</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Pago</th>
                                                                <th class="text-center">Estado</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <!-- Modal -->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <input type="hidden" id="txt-idsemesterenrollment" name="txt-idsemesterenrollment">
        <input type="hidden" id="txt-idstudent" name="txt-idstudent">
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Matricular</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha" class="form-label text-primary">Fecha matricula</label>
                                    <input id="txt-fecha" name="txt-fecha" type="date"
                                        class="form-control form-control-sm" placeholder="" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal -->
    <form id="formModal2" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalDetalleCursos" class="modal fade" tabindex="-1" aria-labelledby="modalDetalleCursosLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalDetalleCursosLabel">Cursos matriculados para el estudiante: </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body pt-0 pb-0">
                        <div class="card mb-0" id="accordion-three">
                            <div class="tab-content" id="myTabContent-2">
                                <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                    aria-labelledby="home-tab-2">
                                    <div class="card-body p-1">
                                        <div class="table-responsive">
                                            <table id="datatableGeneral2"
                                                class="table table-hover table-bordered table-sm display rounded-3"
                                                style="min-width:100%">
                                                <thead class="thead-primary">
                                                    <tr>
                                                        <th class="text-center">Semestre</th>
                                                        <th class="text-center">Código</th>
                                                        <th class="text-center">Nombre</th>
                                                        <th class="text-center">Sección</th>
                                                        
                                                        <th class="text-center">Créditos</th>
                                                        
                                                        <th class="text-center">Estado</th>
                                                        <th class="text-center">Accion</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <!--  -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!-- Scripts -->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/matricula/alumnos_semestre.js']); ?>;
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/matricula/alumnos_semestre/index.blade.php ENDPATH**/ ?>