<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Equivalencias entre Planes</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Equivalencias entre Planes
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de equivalencias entre Planes de Estudio
                                            </h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo registro
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">

                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-3">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Plan Nuevo</th>
                                                                <th class="text-center">Plan Antiguo</th>
                                                                <th class="text-center">Equivalencia</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!-- Modal -->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nueva</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input type="hidden" id="txt-idplanequivalence" name="txt-idplanequivalence">
                                <!-- data -->
                                <div id="div-txt-plans1" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-plans1" class="form-label text-primary">Plan Nuevo</label>
                                    <select id="txt-plans1" name="txt-plans1"
                                        class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione plan</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-plans2" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-plans2" class="form-label text-primary">Plan Antiguo</label>
                                    <select id="txt-plans2" name="txt-plans2"
                                        class="default-select form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione plan</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-document" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-document" class="form-label text-primary">Documento de
                                        Equivalencia</label>
                                    <input id="txt-document" name="txt-document" type="file"
                                        class="form-control form-control-sm">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>






    <!-- Modal -->
    <form id="formModal2" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalDetalleEquivalencias" class="modal fade" tabindex="-1" aria-labelledby="modalDetalleEquivalenciasLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5 me-auto" id="modalDetalleEquivalenciasLabel">Detalle de Equivalencias de curso</h1>
                        <button id="btnCreateModal2" type="button" class="btn btn-primary btn-sm">
                                            + Nueva Equivalencia entre curso
                                        </button>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body pb-0">
                        <div class="row">
                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card mb-0" id="accordion-three">
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-1">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral2"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">curso Plan Nuevo</th>
                                                                <th class="text-center">curso Plan Antiguo</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>



    <!-- Modal -->
    <form id="formModal3" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalCreate2" class="modal fade" tabindex="-1" aria-labelledby="modalCreate2Label"
            aria-hidden="true" style="background: rgba(0, 0, 123, 0.523)">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreate2Label">Registrar nueva Equivalencia de curso</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input type="hidden" id="txt-idplanequivalence2" name="txt-idplanequivalence2">
                                <!-- data -->
                                <div id="div-txt-course1" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-course1" class="form-label text-primary">curso del Plan 1</label>
                                    <select id="txt-course1" name="txt-course1"
                                        class="default-select form-control form-control-sm" data-live-search="true" data-size="8" required>
                                        <option selected disabled value="">Seleccione curso</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-course2" class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-course2" class="form-label text-primary">curso del Plan 2</label>
                                    <select id="txt-course2" name="txt-course2"
                                        class="default-select form-control form-control-sm" data-live-search="true" data-size="8" required>
                                        <option selected disabled value="">Seleccione curso</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreate2" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>



    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/planes_de_estudio/equivalencias.js']); ?>;

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/planes_estudio/equivalencias/index.blade.php ENDPATH**/ ?>