<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Publicaciones</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('/css/preloader.css')); ?>" rel="stylesheet">
    <style>
        #email-left{
            height: auto;
        }
    </style>

</head>

<body>
    <div id="progressSection" style="display: none;"> <!-- Contenedor de la barra de progreso, inicialmente oculto -->
        <div id="porcentaje">0</div>
        <div class="barra_progreso">
            <div class="progreso" id="progreso"></div>
        </div>
    </div>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            <?php echo e(__('Gestionar Encuestas')); ?>

        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <form class="needs-validation" id="formEncuesta">
                    <div class="row">
                        <!--column-->
                        <div class="col-xl-4 col-xxl-4 col-lg-4 col-md-12">
                            <div class="card">
                                <div class="card-header border-0 pb-0">
                                    <div>
                                        <h6 class="heading my-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960"
                                                width="24px" fill="#5f6368">
                                                <path
                                                    d="M160-400v-80h280v80H160Zm0-160v-80h440v80H160Zm0-160v-80h440v80H160Zm360 560v-123l221-220q9-9 20-13t22-4q12 0 23 4.5t20 13.5l37 37q8 9 12.5 20t4.5 22q0 11-4 22.5T863-380L643-160H520Zm300-263-37-37 37 37ZM580-220h38l121-122-18-19-19-18-122 121v38Zm141-141-19-18 37 37-18-19Z" />
                                            </svg>
                                            Datos de la Encuesta
                                        </h6>
                                    </div>
                                    <button id="btn_add_Clear" type="button" value="Clear"
                                        class="btn btn-secondary btn-sm">Limpiar
                                        <svg xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 -960 960 960"
                                            width="16px" fill="#ffff">
                                            <path
                                                d="M280-120q-33 0-56.5-23.5T200-200v-520h-40v-80h200v-40h240v40h200v80h-40v520q0 33-23.5 56.5T680-120H280Zm400-600H280v520h400v-520ZM360-280h80v-360h-80v360Zm160 0h80v-360h-80v360ZM280-720v520-520Z" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="card-body p-0">
                                    <div class="email-left-box border-end  dlab-scroll pb-2" id="email-left">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" id="id_encuesta_hidden">
                                        <div class="row">
                                            <div class="col-lg-12 mb-2">
                                                <div class="mb-3">
                                                    <label class="text-label form-label text-dark"><strong>Titulo</strong>
                                                        <span class="required">*</span></label>
                                                    <input type="text" name="text_titulo" id="text_titulo"
                                                        class="form-control form-control-sm" required>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-2">
                                                <div class="mb-3">
                                                    <label class="text-label form-label text-dark"><strong>Plan</strong>
                                                        <span class="required">*</span></label>

                                                    <select id="txt-plans" name="txt-plans"
                                                        class="default-select form-control form-control-sm" required>
                                                        
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-2">
                                                <div class="mb-3">
                                                    <label class="text-label form-label text-dark"><strong>Estado</strong>
                                                        <span class="required">*</span></label>
                                                    <select class=" default-select form-control form-control-sm wide"
                                                        aria-label="Default select example" id="select_estado"
                                                        name="select_estado">
                                                        <option selected disables value="0">Seleccione opcion </option>
                                                        <option value="activa">Activo</option>
                                                        <option value="inactiva">Inactivo</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-12 mb-2">
                                                <label class="text-label form-label text-dark"><strong>Dirigiado a</strong>
                                                    <span class="required">*</span></label>

                                                <div class="mb-3">
                                                    <div class="form-check d-inline-block">
                                                        <label class="form-check-label">
                                                            <input type="radio" class="form-check-input me-2"
                                                                name="dirigidoName" id="ambos" value="ambos"
                                                                checked="">Ambos
                                                        </label>
                                                    </div>
                                                    <div class="form-check d-inline-block mx-2">
                                                        <label class="form-check-label">
                                                            <input type="radio" class="form-check-input me-2"
                                                                name="dirigidoName" id="alumnos" value="alumnos">ALumnos
                                                        </label>
                                                    </div>
                                                    <div class="form-check d-inline-block disabled">
                                                        <label class="form-check-label">
                                                            <input type="radio" class="form-check-input me-2"
                                                                name="dirigidoName" id="docentes" value="docentes">docentes
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-2">
                                                <div class="mb-3">
                                                    <label class="text-label form-label text-dark"><strong>Fecha
                                                            Inicio</strong> <span class="required">*</span></label>
                                                    <input type="date" name="fch_inicio" id="fch_inicio"
                                                        class="form-control form-control-sm" required>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 mb-2">
                                                <div class="mb-3">
                                                    <label class="text-label form-label text-dark"><strong>Fecha
                                                            Fin</strong> <span class="required">*</span></label>
                                                    <input type="date" name="fch_fin" id="fch_fin"
                                                        class="form-control form-control-sm" required>
                                                </div>
                                            </div>

                                            <div class="col-lg-12 mb-3">
                                                <div class="mb-3">
                                                    <label for="descripcionTxtArea"
                                                        class="form-label text-dark"><strong>Descripcion de
                                                            la encuesta</strong> <span class="required">*</span></label>
                                                    <textarea class="form-control form-control-sm" id="descripcionTxtArea" name="descripcionTxtArea" rows="3"></textarea>

                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button id="btnCreateUpdate" type="button" value="Create"
                                        class="btn btn-primary btn-sm btn-block">Guardar</button>
                                </div>
                            </div>
                        </div>
                        <!--/column-->
                        <!--column-->
                        <div class="col-xl-8 col-xxl-8 col-lg-8 col-lg-12">
                            <div class="card">
                                <div class="card-header border-0 pb-0">
                                    <div class="file-header border-0 w-100">
                                        <div class="page-titles">
                                            <div class="my-2">
                                                <h2 class="heading">Hisotiral de Encuestas</h2>
                                                <div class="file-path">
                                                    <div class="me-2">
                                                        <svg width="20" height="16" viewBox="0 0 20 16"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <path
                                                                d="M18.9833 6.64169C18.9049 6.545 18.8058 6.46712 18.6933 6.41376C18.5808 6.36041 18.4578 6.33293 18.3333 6.33335H16.6666V5.50002C16.6666 4.83698 16.4033 4.20109 15.9344 3.73225C15.4656 3.26341 14.8297 3.00002 14.1666 3.00002H8.93331L8.66665 2.16669C8.49377 1.67771 8.1731 1.2546 7.74906 0.955986C7.32502 0.657367 6.81861 0.498019 6.29998 0.500019H3.33331C2.67027 0.500019 2.03439 0.763411 1.56555 1.23225C1.09671 1.70109 0.833313 2.33698 0.833313 3.00002V13C0.833313 13.6631 1.09671 14.2989 1.56555 14.7678C2.03439 15.2366 2.67027 15.5 3.33331 15.5H15.3333C15.901 15.4984 16.4512 15.3036 16.8935 14.9476C17.3357 14.5917 17.6437 14.0959 17.7666 13.5417L19.1666 7.35002C19.192 7.22578 19.1886 7.0974 19.1569 6.97466C19.1251 6.85191 19.0657 6.73803 18.9833 6.64169ZM4.47498 13.1834C4.43264 13.3713 4.32647 13.5388 4.17453 13.6574C4.02259 13.7759 3.83428 13.8381 3.64165 13.8334H3.33331C3.1123 13.8334 2.90034 13.7456 2.74406 13.5893C2.58778 13.433 2.49998 13.221 2.49998 13V3.00002C2.49998 2.779 2.58778 2.56704 2.74406 2.41076C2.90034 2.25448 3.1123 2.16669 3.33331 2.16669H6.29998C6.4817 2.1572 6.66153 2.20746 6.81201 2.30978C6.96248 2.4121 7.07533 2.56087 7.13331 2.73335L7.58331 4.10002C7.63679 4.25897 7.73698 4.39809 7.87079 4.49919C8.0046 4.60029 8.1658 4.65867 8.33331 4.66669H14.1666C14.3877 4.66669 14.5996 4.75448 14.7559 4.91076C14.9122 5.06704 15 5.27901 15 5.50002V6.33335H6.66665C6.47401 6.32864 6.2857 6.39084 6.13376 6.50935C5.98182 6.62786 5.87565 6.79537 5.83331 6.98335L4.47498 13.1834ZM16.1416 13.1834C16.0993 13.3713 15.9931 13.5388 15.8412 13.6574C15.6893 13.7759 15.5009 13.8381 15.3083 13.8334H6.00831C6.05135 13.7405 6.08216 13.6425 6.09998 13.5417L7.33331 8.00002H17.3333L16.1416 13.1834Z"
                                                                fill="#01A3FF" />
                                                        </svg>
                                                    </div>
                                                    <h4><a id="link1" class="link active" data-opcion="1"
                                                            href="#">Todas /</a><a id="link2" class="link"
                                                            data-opcion="2" href="#">Activas /</a><a id="link3"
                                                            class="link" data-opcion="3" href="#">Culminadas</a>
                                                    </h4>
                                                </div>
                                            </div>
                                            <div class="d-flex my-2">
                                                <div class="input-group search-area ">
                                                    <input type="text" class="form-control"
                                                        placeholder="Search here...">
                                                    <span class="input-group-text"><a href="javascript:void(0)"><svg
                                                                width="15" height="15" viewBox="0 0 18 18"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <path
                                                                    d="M17.5605 15.4395L13.7527 11.6317C14.5395 10.446 15 9.02625 15 7.5C15 3.3645 11.6355 0 7.5 0C3.3645 0 0 3.3645 0 7.5C0 11.6355 3.3645 15 7.5 15C9.02625 15 10.446 14.5395 11.6317 13.7527L15.4395 17.5605C16.0245 18.1462 16.9755 18.1462 17.5605 17.5605C18.1462 16.9747 18.1462 16.0252 17.5605 15.4395V15.4395ZM2.25 7.5C2.25 4.605 4.605 2.25 7.5 2.25C10.395 2.25 12.75 4.605 12.75 7.5C12.75 10.395 10.395 12.75 7.5 12.75C4.605 12.75 2.25 10.395 2.25 7.5V7.5Z"
                                                                    fill="#01A3FF"></path>
                                                            </svg>
                                                        </a>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div id="DZ_W_TimeLine" class="widget-media dlab-scroll height600 my-4 px-4">
                                        <ul id="folder" class="timeline">


                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--/column-->
                    </div>
                </form>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/bienestar/encuestas_Ajax.js']); ?>;
    
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
    <script></script>


</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/bienestar/encuestas/encuesta/index.blade.php ENDPATH**/ ?>