<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Publicaciones</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

    <!-- Bootstrap-select después de jQuery y Bootstrap -->

    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

    <script>
        tinymce.init({
            selector: '#txt-contenido',
            // apiKey: '4sh9d8nudkauw4719swn2o8026yhuxdscvzznkyvp2o0wjzg',
        });
    </script>

    <style>
        .bootstrap-select .dropdown-menu {
            z-index: 2000 !important;
        }
    </style>


</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
        Gestionar Publicaciones
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre Publicaciones</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nueva Publicacion
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Titulo</th>
                                                                <th class="text-center">Contenido</th>
                                                                <th class="text-center">Imagen</th>
                                                                <th class="text-center">Programa</th>
                                                                <th class="text-center">Visualizar</th>
                                                                <th class="text-center">Fecha de Registro</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel">
            <div class="modal-dialog modal-dialog-center modal-xl">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Crear una publicación
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input type="hidden" id="txt-id" name="txt-id">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-program_id" class="form-label text-primary">Programa</label>
                                    <select id="txt-program_id" name="txt-program_id"
                                        class="default-select form-control form-control-sm" placeholder="" required>
                                        
                                    </select>
                                </div>
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-titulo" class="form-label text-primary">Título</label>
                                    <input id="txt-titulo" name="txt-titulo" type="text"
                                        class="form-control form-control-sm" required>
                                </div>
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-contenido" class="form-label text-primary">Contenido</label>
                                    <!-- Aquí va el textarea para CKEditor -->
                                    <div class="card-body custom-ekeditor p-0">
                                        <textarea class="form-control" rows="7" id="txt-contenido"
                                            name="txt-contenido"></textarea>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-dirigido_a" class="form-label text-primary">Visualizable para</label>
                                    <select id="txt-dirigido_a" name="txt-dirigido_a"
                                        class="default-select form-control form-control-sm" placeholder="" required>
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="estudiante">Estudiante</option>
                                        <option value="docente">Docente</option>
                                        <option value="ambos">Todos</option>
                                    </select>
                                </div>
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-imagen" class="form-label text-primary">Imagen</label>
                                    <input id="txt-imagen" name="txt-imagen" type="file" accept="image/*"
                                        class="form-control form-control-sm" required>
                                </div>
                                <!-- data -->
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" value="Create"
                            class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!-- Modal para ver imagen -->
    <div class="modal fade" id="modalImage" tabindex="-1" aria-labelledby="modalImageLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalImageLabel">Visualizar Imagen</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body text-center">
                    <img id="previewImage" src="" alt="Imagen" class="img-fluid rounded">
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para ver contenido -->
    <div class="modal fade" id="modalContent" tabindex="-1" aria-labelledby="modalContentLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalContentLabel">Contenido de la Publicación</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body">
                    <h5 id="contentTitle" class="mb-3 text-primary"></h5>
                    <div id="contentBody" class="border rounded p-3 bg-light"></div>
                </div>
            </div>
        </div>
    </div>


    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        tinymce.init({
        selector: '#txt-contenido',
        menubar: false,
        height: 300,
        plugins: "lists link image preview",
        toolbar: "undo redo | bold italic underline | bullist numlist | link image | preview",
    });
    </script>


    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;


    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/bienestar/publicaciones.js']); ?>;

</body>

</html>
<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/bienestar/publicaciones/index.blade.php ENDPATH**/ ?>