<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\LoginGoogleController;
use App\Models\User;
use Laravel\Socialite\Facades\Socialite;
use \Illuminate\Support\Facades\Auth;

// INICIO DEL PROGRAMA ENTRADA AL WELCOME - LOGIN
Route::middleware('guest')->group(function () {
    Route::get('/', [LoginController::class, 'index'])->name('login');
    Route::get('/login', [LoginController::class, 'index']);

    Route::post('authenticateLogin', [LoginController::class, 'authenticateLogin'])->name('login.authenticate');
    Route::post('profileLogin', [LoginController::class, 'profileLogin']);

    Route::get('/recuperar-contraseña', [LoginController::class, 'forgotPasswordView'])->name('password.request');
    Route::get('/restablecer-contraseña', [LoginController::class, 'resetPasswordView'])->name('password.reset');

    Route::post('/forgot-password', [LoginController::class, 'forgotPassword'])->name('forgot-password');
    Route::post('/reset-password', [LoginController::class, 'resetPassword'])->name('reset-password');
});
// FIN

Route::get('/login-google', function () {
    return Socialite::driver('google')->redirect();
});

Route::get('/google-callback', [LoginGoogleController::class, 'login']);

Route::group(['middleware' => ['checksession', 'checkestado', 'auth.session']], function () {
    Route::post('logout', [LoginController::class, 'logout'])->name('logout');
});
