<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\docente\ZoomController;

/* --   INICIO - FOROS -------------------------- */
Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin,teacher,student']], function () {
    Route::get('/docente/zoom', [ZoomController::class, 'showMeetingsPage'])->name('docente.zoom.index');
    Route::post('/docente/zoom/meetings/create', [ZoomController::class, 'createMeeting'])->name('zoom.meetings.create');
    Route::delete('/docente/zoom/meetings/{meetingId}', [ZoomController::class, 'deleteMeeting'])->name('zoom.meetings.delete');
    Route::get('/docente/zoom/meetings/filter', [ZoomController::class, 'getFilteredMeetings']);
    Route::delete('/docente/zoom/meetings/delete/{meetingId}', [ZoomController::class, 'deleteMeetingAndDatabase'])->name('zoom.meetings.delete');
    Route::get('/docente/zoom/meetings/{id_zoom_meeting}', [ZoomController::class, 'getLinkMeetingZoom']);
    Route::post('/docente/zoom/meeting/class', [ZoomController::class, 'createZoomMeetingForClass'])->name('docente.zoom.createForClass');
    Route::post('/alumno/zoom/meeting', [ZoomController::class, 'getLinkMeetingZoom_Alumnos'])->name('alumno.zoom.getLinkMeetingZoom');
});
/* ----- FIN -   --------------------------*/
