<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\docente\ActivityDocenteController;
use App\Http\Controllers\docente\GradeDocenteController;
use App\Http\Controllers\docente\GradetypeController;
use App\Http\Controllers\docente\IndicatorDocenteController;
use App\Http\Controllers\docente\NotaController as DocenteNotaController;


/* --   INICIO - NOTAS DOCENTES --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:teacher']], function () {
  // INDICADORES - INICIO
  Route::get('/docente/notas/indicadores', [IndicatorDocenteController::class, 'index'])->name('docente.notas.gestionar_indicadores');
  Route::post('/docente/notas/indicadores/list', [IndicatorDocenteController::class, 'list']);
  Route::post('/docente/notas/indicadores/store', [IndicatorDocenteController::class, 'store']);
  Route::put('/docente/notas/indicadores/update/{id}', [IndicatorDocenteController::class, 'update']);
  Route::delete('/docente/notas/indicadores/destroy/{id}', [IndicatorDocenteController::class, 'destroy']);
  // INDICADORES - FIN

  // ACTIVIDADES - INICIO
  Route::post('/docente/notas/actividades/list', [ActivityDocenteController::class, 'list']);
  Route::post('/docente/notas/actividades/store', [ActivityDocenteController::class, 'store']);
  Route::put('/docente/notas/actividades/update/{id}', [ActivityDocenteController::class, 'update']);
  Route::delete('/docente/notas/actividades/destroy/{id}', [ActivityDocenteController::class, 'destroy']);
  // ACTIVIDADES - FIN

  // NOTAS - INICIO
  Route::post('/docente/notas/notas/list', [GradeDocenteController::class, 'list']);
  Route::post('/docente/notas/notas/store', [GradeDocenteController::class, 'store']);
  Route::put('/docente/notas/notas/update/{id}', [GradeDocenteController::class, 'update']);
  Route::delete('/docente/notas/notas/destroy/{id}', [GradeDocenteController::class, 'destroy']);
  // NOTAS - FIN


  // TIPOS NOTAS - INICIO
  Route::get('/admin/notas/tipos_notas', [GradetypeController::class, 'index'])->name('admin.notas.tipos_notas');
  Route::get('/admin/notas/tipos_notas/list', [GradetypeController::class, 'list']);
  Route::post('/admin/notas/tipos_notas/store', [GradetypeController::class, 'store']);
  Route::put('/admin/notas/tipos_notas/update/{id}', [GradetypeController::class, 'update']);
  Route::delete('/admin/notas/tipos_notas/destroy/{id}', [GradetypeController::class, 'destroy']);
  // TIPOS NOTAS - FIN


  Route::get('/docente/notas', [DocenteNotaController::class, 'index'])->name('docente.notas.gestionar_notas');
  Route::post('/docente/notas/list_cursos', [DocenteNotaController::class, 'list_cursos']);
  Route::post('/docente/notas/list_indicadores', [DocenteNotaController::class, 'list_indicadores']);
  Route::post('/docente/notas/list_estudiantes', [DocenteNotaController::class, 'list_estudiantes']);
  Route::put('/docente/notas/gestionar_nota/update_nota/{idstudentgrade}/{idsubjectenrollment}', [DocenteNotaController::class, 'update_nota']);
  Route::post('/docente/notas/guardar-notas-lote', [DocenteNotaController::class, 'update_notas_lote']);
  Route::post('/docente/notas/ver-evidencia/{id}', [DocenteNotaController::class, 'downloadEvidence']);

  //Agregado
  Route::get('/docente/promedios', [DocenteNotaController::class, 'index2'])->name('docente.notas.promedios');
  Route::post('/docente/promedios/list_promedios', [DocenteNotaController::class, 'list_promedios']);
  Route::post('/docente/promedios/list_promedio_estudiante', [DocenteNotaController::class, 'list_promedio_estudiante']);
});
/* ----- FIN - MODULO NOTAS  --------------------------*/
