<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\docente\MaterialesRecursosController;


/* --   INICIO - MATERIALES Y RECURSOS -------------------------- */
Route::group(['middleware' => ['checksession', 'checkestado',  'role:teacher']], function () {
    Route::get('/docente/materiales_recursos', [MaterialesRecursosController::class, 'index'])->name('docente.materiales_recursos');
    Route::get('/docente/materiales_recursos/ajax_all/asignaturas/{idsemester}', [MaterialesRecursosController::class, 'ajax_all']);

    Route::get('/docente/carpetas/list/{idsubject}', [MaterialesRecursosController::class, 'list_folders']);
    Route::post('/docente/carpetas/store', [MaterialesRecursosController::class, 'store_folder']);
    Route::put('/docente/carpetas/update/{idfolder}', [MaterialesRecursosController::class, 'update_folder']);
    Route::delete('/docente/carpetas/delete/{idfolder}', [MaterialesRecursosController::class, 'destroy_folder']);

    Route::get('/docente/subcarpetas/list/{idfolder}', [MaterialesRecursosController::class, 'list_subfolders']);
    Route::post('/docente/subcarpetas/store', [MaterialesRecursosController::class, 'store_subfolder']);
    Route::put('/docente/subcarpetas/update/{idsubfolder}', [MaterialesRecursosController::class, 'update_subfolder']);
    Route::delete('/docente/subcarpetas/delete/{idsubfolder}', [MaterialesRecursosController::class, 'destroy_subfolder']);

    Route::get('/docente/archivos_carpetas/list/{idsubfolder}', [MaterialesRecursosController::class, 'list_folderfiles']);
    Route::post('/docente/archivos_carpetas/store', [MaterialesRecursosController::class, 'store_folderfile']);
    // Route::put('/docente/archivos_carpetas/update/{idfolderfile}', [MaterialesRecursosController::class, 'update_folderfile']);
    Route::delete('/docente/archivos_carpetas/delete/{idfolderfile}', [MaterialesRecursosController::class, 'destroy_folderfile']);
    Route::get('/docente/archivos_carpetas/download/{idfolderfile}', [MaterialesRecursosController::class, 'download_folderfile']);
    Route::get('/docente/viewfile/{codcurso}/{carpeta}/{archivo}', [MaterialesRecursosController::class, 'viewfileEventoAsignado']);

    /* -- SÍLABO RUTAS -- */
    Route::post('/docente/syllabus/upload', [MaterialesRecursosController::class, 'upload_syllabus']);
    Route::get('/docente/syllabus/view/{idsubject}', [MaterialesRecursosController::class, 'view_syllabus']);
    /* -------------------- */
});
/* ----- FIN -   --------------------------*/
