<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\docente\ForumController;

/* --   INICIO - FOROS -------------------------- */
Route::group(['middleware' => ['checksession', 'checkestado',  'role:teacher']], function () {
    Route::get('/docente/foros', [ForumController::class, 'index'])->name('docente.foros');
    Route::get('/docente/foros/list/{idsubject}', [ForumController::class, 'list']);
    Route::get('/docente/respuestas_foros/list/{idforum}', [ForumController::class, 'list_forum_answers']);
    Route::post('/docente/foros/store', [ForumController::class, 'store']);
    Route::post('/docente/foros/update/{idforum}', [ForumController::class, 'update']);
    Route::delete('/docente/foros/delete/{idforum}', [ForumController::class, 'destroy']);
});
/* ----- FIN -   --------------------------*/
