<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\FileController;
use App\Http\Controllers\tramite_documentario\TdCancelarController;
use App\Http\Controllers\tramite_documentario\TdGestionarController;
use App\Http\Controllers\tramite_documentario\TdMisTramitesController;
use App\Http\Controllers\tramite_documentario\TdMovimientoController;
use App\Http\Controllers\tramite_documentario\TdRegistrarController;
use App\Http\Controllers\tramite_documentario\TdResponderController;
use App\Http\Controllers\TramiteDocumentarioController;


Route::prefix('/tramite_documentario')->group(function () {
    Route::get('/registrar', [TdRegistrarController::class, 'index_libre'])->name('tramite_documentario.registrar');
    Route::get('/consulta', [TramiteDocumentarioController::class, 'index_consulta'])->name('tramite_documentario.consulta');
    Route::post('/registrar', [TdRegistrarController::class, 'registrar_libre']);

    Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin,teacher,student']], function () {
        Route::get('/gestionar', [TdGestionarController::class, 'index_libre'])->name('tramite_documentario.gestionar');
        Route::post('/movimientos/datatable', [TdMovimientoController::class, 'datatable']);
        Route::post('/movimientos/{td_id}', [TdMovimientoController::class, 'store_by_td_id']);

        Route::post('/responder/{td_id}', [TdResponderController::class, 'responder']);
        Route::post('/responder_movimiento/{td_movimiento_id}', [TdResponderController::class, 'responder_movimiento']);

        Route::post('/cancelar/{td_id}', [TdCancelarController::class, 'cancelar']);
        Route::post('/cancelar_movimiento/{td_movimiento_id}', [TdCancelarController::class, 'cancelar_movimiento']);

        Route::get('/gestionar/datatable', [TdGestionarController::class, 'datatable_libre']);
        Route::get('/gestionar_nuevos/datatable', [TdGestionarController::class, 'datatable_nuevos_libre']);
        Route::get('/documento', [FileController::class, 'verTramiteDocumentario']);
        Route::get('/documento_respuesta', [FileController::class, 'verTramiteDocumentarioRespuesta']);
    });
});

// API
Route::prefix('/api/tramite_documentario')->group(function () {
    Route::get('/codigo/{codigo}', [TramiteDocumentarioController::class, 'findOneByCodigo']);
});
