<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\AdministratorProfileController;
use App\Http\Controllers\admin\StudentProfileController;
use App\Http\Controllers\admin\TeacherProfileController;

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin']], function () {
    // ajax para obtener registros - INICIO
    Route::get('/admin/profile', [AdministratorProfileController::class, 'index'])->name('admin.profile');
    Route::get('/admin/profile/data', [AdministratorProfileController::class, 'data']);
    Route::put('/admin/profile/update', [AdministratorProfileController::class, 'update']);
    Route::put('/admin/profile/update_password', [AdministratorProfileController::class, 'update_password']);
});

Route::group(['middleware' => ['checksession', 'checkestado',  'role:teacher']], function () {
    // ajax para obtener registros - INICIO
    Route::get('/teacher/profile', [TeacherProfileController::class, 'index'])->name('teacher.profile');
    Route::get('/teacher/profile/data', [TeacherProfileController::class, 'data']);
    Route::put('/teacher/profile/update', [TeacherProfileController::class, 'update']);
    Route::put('/teacher/profile/update_password', [TeacherProfileController::class, 'update_password']);
});

Route::group(['middleware' => ['checksession', 'checkestado',  'role:student']], function () {
    // ajax para obtener registros - INICIO
    Route::get('/student/profile', [StudentProfileController::class, 'index'])->name('student.profile');
    Route::get('/student/profile/data', [StudentProfileController::class, 'data']);
    Route::put('/student/profile/update', [StudentProfileController::class, 'update']);
    Route::put('/student/profile/update_password', [StudentProfileController::class, 'update_password']);
});
