<?php

use App\Http\Controllers\alumno\HomeworkController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['checksession', 'checkestado', 'role:student']], function () {

    Route::get('/alumno/tareas', [HomeworkController::class, 'index'])->name('alumno.tareas');

    Route::get('/alumno/tareas/get-periodos', [HomeworkController::class, 'getPeriods']);
    Route::get('/alumno/tareas/get-cursos/{period_id}', [HomeworkController::class, 'getCourses']);
    Route::get('/alumno/tareas/get-actividades/{asignatura_id}', [HomeworkController::class, 'getTasks']);
    Route::post('/alumno/tareas/upload', [HomeworkController::class, 'uploadHomework']);

});
