<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\alumno\AlumnoOfertasLaboralesController;
use App\Http\Controllers\alumno\AlumnoPostulacionesController;
use App\Http\Controllers\admin\JpcategoryController;
use App\Http\Controllers\admin\JpcompanyController;


/* --- INICIO - OFERTAS LABORALES  --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'role:student']], function () {
  Route::get('/alumno/ofertas_laborales', [AlumnoOfertasLaboralesController::class, 'index'])->name('alumno.ofertas_laborales');
  Route::get('/alumno/ofertas_laborales/listar', [AlumnoOfertasLaboralesController::class, 'listar']);
  Route::post('/alumno/ofertas_laborales/store', [AlumnoOfertasLaboralesController::class, 'store']);
  Route::get('/alumno/ofertas_laborales/cantidad_ofertas', [AlumnoOfertasLaboralesController::class, 'cantidad_ofertas']);
});
/* ----- FIN - OFERTAS LABORALES  --------------------------*/



/* --- INICIO - POSTULACIONES  --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'role:student']], function () {
  Route::get('/alumno/postulaciones', [AlumnoPostulacionesController::class, 'index'])->name('alumno.postulaciones');
  Route::get('/alumno/postulaciones/list', [AlumnoPostulacionesController::class, 'list']);
  Route::get('/alumno/postulaciones/categorias', [JpcategoryController::class, 'ajax_all']);
  Route::get('/alumno/postulaciones/empresas', [JpcompanyController::class, 'ajax_all']);
});
/* ----- FIN - POSTULACIONES  --------------------------*/
