<?php

use App\Http\Controllers\alumno\EncuestasController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\alumno\PublicacionesController;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;


/* --- INICIO - OFERTAS LABORALES  --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin,teacher,student']], function () {
  Route::get('/alumno/modele/publicaciones', [PublicacionesController::class, 'index'])->name('alumno.modele.publicaciones');
  // Route::get('/alumno/ofertas_laborales/listar', [PublicacionesController::class, 'listar']);
  // Route::get('/alumno/publicaciones/viewimg/{idpublicacion}/{carpeta}/{imagen}', [PublicacionesController::class, 'verImagen']);


  Route::get('/alumno/encuestas/solve/{encuesta}', [EncuestasController::class, 'index'])->name('alumno.encuestas.solve')->middleware('signed');
  Route::post('/guardar-respuestas', [EncuestasController::class, 'store'])->name('guardar.respuestas');


});
/* ----- FIN - OFERTAS LABORALES  --------------------------*/


