<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\FileController;
use App\Http\Controllers\registros_pagos\BancoController;
use App\Http\Controllers\registros_pagos\ConceptoController;
use App\Http\Controllers\registros_pagos\MetodoPagoController;
use App\Http\Controllers\registros_pagos\PagoController;
use App\Http\Controllers\registros_pagos\TesoreriaReporteController;
use App\Http\Controllers\registros_pagos\ViaticoController;
use App\Http\Controllers\reportes\ReportesController;

/* --------------------------
    INICIO - PAGOS
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin,teacher,student']], function () {

  // BANCOS - INICIO
  Route::get('/admin/registros_pagos/bancos', [BancoController::class, 'index'])->name('admin.registros_pagos.bancos');
  Route::post('/admin/registros_pagos/bancos/list', [BancoController::class, 'list']);
  Route::post('/admin/registros_pagos/bancos/store', [BancoController::class, 'store']);
  Route::put('/admin/registros_pagos/bancos/update/{id}', [BancoController::class, 'update']);
  Route::delete('/admin/registros_pagos/bancos/destroy/{id}', [BancoController::class, 'destroy']);
  // BANCOS - FIN

  // CONCEPTOS - INICIO
  Route::get('/admin/registros_pagos/conceptos', [ConceptoController::class, 'index'])->name('admin.registros_pagos.conceptos');
  Route::post('/admin/registros_pagos/conceptos/list', [ConceptoController::class, 'list']);
  Route::post('/admin/registros_pagos/conceptos/store', [ConceptoController::class, 'store']);
  Route::put('/admin/registros_pagos/conceptos/update/{id}', [ConceptoController::class, 'update']);
  Route::delete('/admin/registros_pagos/conceptos/destroy/{id}', [ConceptoController::class, 'destroy']);
  // CONCEPTOS - FIN


  // METODOS DE PAGO - INICIO
  Route::get('/admin/registros_pagos/metodos_pagos', [MetodoPagoController::class, 'index'])->name('admin.registros_pagos.metodos_pagos');
  Route::post('/admin/registros_pagos/metodos_pagos/list', [MetodoPagoController::class, 'list']);
  Route::post('/admin/registros_pagos/metodos_pagos/store', [MetodoPagoController::class, 'store']);
  Route::put('/admin/registros_pagos/metodos_pagos/update/{id}', [MetodoPagoController::class, 'update']);
  Route::delete('/admin/registros_pagos/metodos_pagos/destroy/{id}', [MetodoPagoController::class, 'destroy']);
  // METODOS DE PAGO - FIN


  // PAGOS - INICIO
  Route::get('/admin/registros_pagos/pagos', [PagoController::class, 'index'])->name('admin.registros_pagos.pagos');
  Route::post('/admin/registros_pagos/pagos/list', [PagoController::class, 'list']);
  Route::post('/admin/registros_pagos/pagos/store', [PagoController::class, 'store']);
  Route::get('/verPagoMatricula/{idpago}', [FileController::class, 'verPagoMatricula']);
  Route::post('/admin/registros_pagos/pagos/update', [PagoController::class, 'update']);
  Route::delete('/admin/registros_pagos/pagos/destroy/{id}', [PagoController::class, 'destroy']);
  // PAGOS - FIN


  // VIATICO - INICIO
  Route::get('/admin/registros_pagos/viaticos', [ViaticoController::class, 'index'])->name('admin.registros_pagos.viaticos');
  Route::post('/admin/registros_pagos/viaticos/list', [ViaticoController::class, 'list']);
  Route::post('/admin/registros_pagos/viaticos/store', [ViaticoController::class, 'store']);
  Route::get('/verDocumentoViatico/{idviatico}', [FileController::class, 'verDocumentoViatico']);
  Route::post('/admin/registros_pagos/viaticos/update', [ViaticoController::class, 'update']);
  Route::delete('/admin/registros_pagos/viaticos/destroy/{id}', [ViaticoController::class, 'destroy']);
  // VIATICO - FIN

  // REPORTES TESORERIA - INICIO
  Route::get('/admin/registros_pagos/reportes', [TesoreriaReporteController::class, 'index'])->name('admin.registros_pagos.reportes');
  Route::get('/admin/registros_pagos/reportes/grafica_1/{anho}/{mesini}/{mesfin}', [TesoreriaReporteController::class, 'grafica_1']);
  Route::get('/admin/registros_pagos/reportes/grafica_2/{anho}/{mesini}/{mesfin}/{idstudent}', [TesoreriaReporteController::class, 'grafica_2']);
  Route::get('/admin/registros_pagos/reportes/grafica_3/{anho}/{mesini}/{mesfin}', [TesoreriaReporteController::class, 'grafica_3']);
  Route::get('/admin/registros_pagos/reportes/grafica_4/{anho}/{mesini}/{mesfin}', [TesoreriaReporteController::class, 'grafica_4']);
  Route::get('/admin/registros_pagos/reportes/listado/{anho}/{mesini}/{mesfin}', [TesoreriaReporteController::class, 'listado']);
  Route::get('/admin/registros_pagos/reportes/grafica_5/{anho}/{mesini}/{mesfin}', [TesoreriaReporteController::class, 'grafica_5']);
  Route::get('/admin/registros_pagos/reportes/ingresos_egresos/{anho}/{mesini}/{mesfin}', [TesoreriaReporteController::class, 'ingresos_egresos']);
  // REPORTES TESORERIA - FIN

  // BOLETA PAGO - INICIO
  Route::get('/admin/registros_pagos/boleta_pago/{idpago}', [ReportesController::class, 'boleta_pago']);
  // BOLETA PAGO - FIN
});
  /* --------------------------
          FIN - PAGOS
          --------------------------*/
