<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\AdministratorController;
use App\Http\Controllers\admin\PermissionController;
use App\Http\Controllers\admin\RoleController;
use App\Http\Controllers\Backup\BackupBdController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\admin\AuditController;

/* --------------------------
    INICIO - SEGURIDAD
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin', 'module:seguridad']], function () {
    // ADMINISTRADORES - INICIO
    Route::prefix('/admin/seguridad/administradores')->group(function () {
        Route::get('', [AdministratorController::class, 'index'])->name('admin.seguridad.administradores');
        Route::post('/list', [AdministratorController::class, 'list']);
        Route::post('/store', [AdministratorController::class, 'store']);
        Route::put('/update/{id}', [AdministratorController::class, 'update']);
        Route::put('/update_password/{id}', [AdministratorController::class, 'update_password']);
        Route::delete('/destroy/{id}', [AdministratorController::class, 'destroy']);
        Route::post('/plantilla/download', [AdministratorController::class, 'downloadExcelFile']);
        Route::post('/storePlantilla', [AdministratorController::class, 'store_plantilla']);
    });
    // ADMINISTRADORES - FIN

    // ROLES - INICIO
    Route::get('/admin/seguridad/roles', [RoleController::class, 'index'])->name('admin.seguridad.roles');
    Route::get('/admin/seguridad/roles/listar', [RoleController::class, 'list'])->name('admin.seguridad.roles.list');
    Route::post('post-roles', [RoleController::class, 'store'])->name('admin.seguridad.roles.store');
    Route::put('/update-roles/{id}', [RoleController::class, 'update'])->name('admin.seguridad.roles.update');
    Route::delete('/delete-roles/{id}', [RoleController::class, 'destroy'])->name('elementos.eliminar');
    // ROLES - FIN

    // MODULOS PERMISOS- INICIO
    Route::get('/admin/seguridad/permisos', [PermissionController::class, 'index'])->name('admin.seguridad.permisos');
    Route::post('/admin/seguridad/permisos/list', [PermissionController::class, 'list']);
    Route::put('/admin/seguridad/accion/{idpermiso}', [PermissionController::class, 'update_accion']);
    Route::put('/admin/seguridad/{idrol}/{idmodulo}', [PermissionController::class, 'update']);
    // MODULOS - FIN

    // MODULOS BACKUP- INICIO
    Route::get('/admin/seguridad/backupbd', [BackupBdController::class, 'index'])->name('admin.seguridad.backupbd');
    Route::get('/admin/seguridad/list/backupbd', [BackupBdController::class, 'list'])->name('admin.seguridad.list.backupbd');
    Route::get('/admin/seguridad/download/backupbd/archivozip', [BackupBdController::class, 'DownloadBaseDatos'])->name('admin.seguridad.download.backupbd');
    Route::post('/admin/seguridad/create/backupbd', [BackupBdController::class, 'createBackupBD'])->name('admin.seguridad.create.backupbd');
    // MODULOS - FIN

    // ADMINISTRADORES - INICIO
    Route::prefix('/admin/seguridad/usuarios_nuevos')->group(function () {
        Route::get('', [UserController::class, 'index'])->name('admin.seguridad.usuarios_nuevos');
        Route::post('/list', [UserController::class, 'list']);
        Route::post('/store', [UserController::class, 'store']);
        Route::put('/update/{id}', [UserController::class, 'update']);
        Route::put('/update_password/{id}', [UserController::class, 'update_password']);
        Route::delete('/destroy/{id}', [UserController::class, 'destroy']);
    });
    // ADMINISTRADORES - FIN

    // USUARIOS - INICIO
    Route::prefix('/admin/seguridad/usuarios')->group(function () {
        Route::get('', [UserController::class, 'index'])->name('admin.seguridad.usuarios');
        Route::post('/list', [UserController::class, 'list']);
        Route::post('/store', [UserController::class, 'store']);
        Route::put('/update/{id}', [UserController::class, 'update']);
        Route::put('/update_password/{id}', [UserController::class, 'update_password']);
        Route::delete('/destroy/{id}', [UserController::class, 'destroy']);
        Route::post('/plantilla/download', [UserController::class, 'downloadExcelFile']);
        Route::post('/storePlantilla', [UserController::class, 'store_plantilla']);
    });
    // USUARIOS - FIN

    // MODULOS AUDITORIA - INICIO
    Route::get('/admin/seguridad/auditoria', [AuditController::class, 'index'])->name('admin.seguridad.auditoria');
    Route::post('/admin/seguridad/auditoria/list', [AuditController::class, 'list']);
    // MODULOS AUDITORIA - FIN
});
/* --------------------------
    FIN - SEGURIDAD
    --------------------------*/
