<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\StudentSituacionController;
use App\Http\Controllers\admin\StudentItemsTitulacionController;
use App\Http\Controllers\admin\StudentDocumentosTitulacionController;

/* --------------------------
    INICIO - SEGUIMIENTO AL EGRESADO
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin,teacher,student', 'module:seguimiento_egresado']], function () {
    // GESTIONAR SITUACION DE ESTUDIANTES - INICIO
    Route::get('/admin/seguimiento_egresado/egresados', [StudentSituacionController::class, 'index'])->name('admin.seguimiento_egresado.situacion_estudiante');
    Route::post('/admin/bolsa_laboral/situacion_estudiante/list_estudiantes/', [StudentSituacionController::class, 'list_estudiantes']);
    Route::put('/admin/bolsa_laboral/situacion_estudiante/update_estudiante/{id}', [StudentSituacionController::class, 'update_estudiante']);
    Route::post('/admin/bolsa_laboral/situacion_estudiante/list_egresados', [StudentSituacionController::class, 'list_egresados']);
    Route::put('/admin/bolsa_laboral/situacion_estudiante/update_egresado/{id}', [StudentSituacionController::class, 'update_egresado']);
    Route::post('/admin/bolsa_laboral/situacion_estudiante/store_egresado', [StudentSituacionController::class, 'store_egresado']);
    // GESTIONAR SITUACION DE ESTUDIANTES - FIN

    Route::get('/admin/seguimiento_egresado/sistema_conecta', [StudentSituacionController::class, 'sistema_conecta'])->name('admin.seguimiento_egresado.sistema_conecta');


    // GESTIONAR TEMS DE TITULACION - INICIO
    Route::get('/admin/seguimiento_egresado/items_titulacion', [StudentItemsTitulacionController::class, 'index'])->name('admin.seguimiento_egresado.items_titulacion');
    Route::get('/admin/seguimiento_egresado/items_titulacion/list', [StudentItemsTitulacionController::class, 'list']);
    Route::post('/admin/seguimiento_egresado/items_titulacion/store', [StudentItemsTitulacionController::class, 'store']);
    Route::put('/admin/seguimiento_egresado/items_titulacion/update/{id}', [StudentItemsTitulacionController::class, 'update']);
    Route::delete('/admin/seguimiento_egresado/items_titulacion/destroy/{id}', [StudentItemsTitulacionController::class, 'destroy']);
    Route::put('/admin/seguimiento_egresado/items_titulacion/updateestado/{id}', [StudentItemsTitulacionController::class, 'updateestado']);
    // GESTIONAR ITEMS DE TITULACION - FIN


    // GESTIONAR DOCUMENTOS DE TITULACION - INICIO
    Route::get('/admin/seguimiento_egresado/documentos_titulacion', [StudentDocumentosTitulacionController::class, 'index'])->name('admin.seguimiento_egresado.documentos_titulacion');
    Route::post('/admin/seguimiento_egresado/documentos_titulacion/list', [StudentDocumentosTitulacionController::class, 'list']);
    Route::get('/admin/seguimiento_egresado/documentos_titulacion/list_itemstitulacion', [StudentDocumentosTitulacionController::class, 'list_itemstitulacion']);
    Route::post('/admin/seguimiento_egresado/documentos_titulacion/store', [StudentDocumentosTitulacionController::class, 'store']);
    Route::put('/admin/seguimiento_egresado/documentos_titulacion/update/{idstudentdocument}', [StudentDocumentosTitulacionController::class, 'update']);
    Route::delete('/admin/seguimiento_egresado/documentos_titulacion/destroy/{idstudentdocument}', [StudentDocumentosTitulacionController::class, 'destroy']);
    Route::put('/admin/seguimiento_egresado/documentos_titulacion/updateestado/{idstudentdocument}', [StudentDocumentosTitulacionController::class, 'updateestado']);
    Route::put('/admin/seguimiento_egresado/documentos_titulacion/updatepermiso_observacion/{idstudentdocument}', [StudentDocumentosTitulacionController::class, 'updatepermiso_observacion']);
    Route::get('/admin/seguimiento_egresado/documentos_titulacion/ver/{idstudentdocument}', [StudentDocumentosTitulacionController::class, 'verDocumentoTitulacion'])->name('admin.seguimiento_egresado.documentos_titulacion.ver');
    // GESTIONAR DOCUMENTOS DE TITULACION - FIN



});
/* --------------------------
    FIN - SEGUIMIENTO AL EGRESADO
    --------------------------*/
