<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\CourseController;
use App\Http\Controllers\admin\SemesterperiodController;
use App\Http\Controllers\admin\SubjectController;
use App\Http\Controllers\FileController;

/* --------------------------
    INICIO - PORTAFOLIO CURSOS
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:cursos']], function () {
    // PERIODOS ACADEMICOS POR PERIODOS LECTIVOS - INICIO
    Route::get('/admin/cursos/periodos_semestre', [SemesterperiodController::class, 'index'])->name('admin.cursos.periodos_semestre');
    Route::post('/admin/cursos/periodos_semestre/list', [SemesterperiodController::class, 'list']);
    Route::post('/admin/cursos/periodos_semestre/store', [SemesterperiodController::class, 'store']);
    Route::delete('/admin/cursos/periodos_semestre/destroy/{id}', [SemesterperiodController::class, 'destroy']);
    Route::post('/admin/cursos/periodos_semestre/list_by_idperiod', [CourseController::class, 'list_by_idperiod']);
    // PERIODOS ACADEMICOS POR PERIODOS LECTIVOS - FIN

    // Agrega esta ruta dentro del grupo de middleware existente
    Route::get('/admin/cursos/asignaturas/analisis-rendimiento/{idsubject}', [SubjectController::class, 'analisisRendimiento']);

    // ASIGNATURAS - INICIO
    Route::get('/admin/cursos/asignaturas', [SubjectController::class, 'index'])->name('admin.cursos.asignaturas');
    Route::post('/admin/cursos/asignaturas/list', [SubjectController::class, 'list']);
    Route::post('/admin/cursos/asignaturas/store', [SubjectController::class, 'store']);
    Route::post('/admin/cursos/asignaturas/update/{id}', [SubjectController::class, 'update']);
    Route::put('/admin/cursos/asignaturas/update_teacher/{idsubject}', [SubjectController::class, 'update_teacher']);
    Route::delete('/admin/cursos/asignaturas/destroy/{id}', [SubjectController::class, 'destroy']);
    // ASIGNATURAS - FIN


    // EFSRT - INICIO
    Route::get('/admin/cursos/efsrt', [SubjectController::class, 'index'])->name('admin.cursos.efsrt');
    Route::post('/admin/cursos/efsrt/list', [SubjectController::class, 'list']);
    Route::post('/admin/cursos/efsrt/store', [SubjectController::class, 'store']);
    Route::post('/admin/cursos/efsrt/update/{id}', [SubjectController::class, 'update']);
    Route::delete('/admin/cursos/efsrt/destroy/{id}', [SubjectController::class, 'destroy']);
    // EFSRT - FIN
});

Route::group(['middleware' => ['checksession', 'checkestado']], function () {
    Route::get('/verSilabo/{idsubject}', [FileController::class, 'verSilabo']);
    Route::get('/verInstrumentosEvaluacion/{idsubject}', [FileController::class, 'verInstrumentosEvaluacion']);
});

/* --------------------------
    FIN - PORTAFOLIO CURSOS
    --------------------------*/
