<?php

use App\Http\Controllers\admin\CourseequivalenceController;
use App\Http\Controllers\admin\PeriodController;
use App\Http\Controllers\admin\PlanController;
use App\Http\Controllers\admin\PlanequivalenceController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\planes\DownloadExcelController;
use App\Http\Controllers\planes\UploadExcelController;
use App\Http\Controllers\admin\EvaluacionCurricularController;
use Illuminate\Support\Facades\Route;

/* --------------------------
    INICIO - PLANES DE ESTUDIO
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:planes_estudio']], function () {
    // GESTIONAR PLANES - INICIO
    Route::get('/admin/planes_estudio/importar', [PlanController::class, 'importar'])->name('admin.planes_estudio.importar');
    Route::get('/admin/planes_estudio/planes', [PlanController::class, 'index'])->name('admin.planes_estudio.planes');
    Route::delete('/admin/planes_estudio/planes/destroy/{id}', [PlanController::class, 'destroy']);
    Route::get('/admin/planes_estudio/planes/list', [PlanController::class, 'list'])->name('admin.planes_estudio.planes.list');
    Route::post('/admin/planes_estudio/planes/store', [PlanController::class, 'store']);
    Route::post('/admin/planes_estudio/planes/update', [PlanController::class, 'update']);
    Route::get('/verDocumentoPlan/{idplan}', [PlanController::class, 'verDocumentoPlan']);
    Route::post('/admin/planes_estudio/planes/download', [DownloadExcelController::class, 'downloadExcelFile'])->name('admin.planes_estudio.planes.download');
    Route::post('/admin/planes_estudio/planes/upload/{idplan}/{option}', [UploadExcelController::class, 'uploadExcelFile'])->name('admin.planes_estudio.planes.upload');
    Route::put('/admin/planes_estudio/planes/update/course/{id}', [UploadExcelController::class, 'uploadcourse'])->name('admin.planes_estudio.planes.update.course');
    Route::post('/admin/institucion/planes/ajax_all_by_idPLan_curses', [PlanController::class, 'ajax_all_by_idPLan_curses'])->name('admin.institucion.planes.ajax_all_by_idPLan_curses');
    Route::post('/admin/planes_estudio/planes/list_by_idplan', [PlanController::class, 'list_by_idplan']);
    // GESTIONAR PLANES - FIN

    // GESTIONAR EQUIVALENCIA DE PLANES - INICIO
    Route::get('/admin/planes_estudio/equivalencias', [PlanequivalenceController::class, 'index'])->name('admin.planes_estudio.equivalencias');
    Route::post('/admin/planes_estudio/equivalencias/list', [PlanequivalenceController::class, 'list']);
    Route::post('/admin/planes_estudio/equivalencias/store', [PlanequivalenceController::class, 'store']);
    Route::post('/admin/planes_estudio/equivalencias/update/{idplanequivalence}', [PlanequivalenceController::class, 'update']);
    Route::delete('/admin/planes_estudio/equivalencias/destroy/{idplanequivalence}', [PlanequivalenceController::class, 'destroy']);
    Route::get('/verDocumentoEquivalencia/{idprogram}/{idplanequivalence}', [FileController::class, 'verDocumentoEquivalencia']);
    // GESTIONAR EQUIVALENCIA DE PLANES - FIN

    // GESTIONAR EQUIVALENCIA DE CURSOS - INICIO
    Route::post('/admin/planes_estudio/equivalencias_cursos/list_by_idplanequivalence', [CourseequivalenceController::class, 'list_by_idplanequivalence']);
    Route::post('/admin/planes_estudio/equivalencias_cursos/store', [CourseequivalenceController::class, 'store']);
    Route::delete('/admin/planes_estudio/equivalencias_cursos/destroy/{idcourseequivalence}', [CourseequivalenceController::class, 'destroy']);

    // GESTIONAR EQUIVALENCIA DE CURSOS - FIN

    // GESTIONAR PERIODOS - INICIO
    Route::post('/admin/planes_estudio/periodo/store/{id}', [PeriodController::class, 'store'])->name('admin.institucion.periodo.store');
    // GESTIONAR PERIODOS - FIN

    //EVALUACION CURRICULAR - INICIO
    Route::get('/admin/planes_estudio/evaluacion', [EvaluacionCurricularController::class, 'index'])->name('admin.planes_estudio.evaluacion');
    Route::get('/admin/planes_estudio/evaluacion/grafica_1/{programa}', [EvaluacionCurricularController::class, 'grafica_1']);
    Route::get('/admin/planes_estudio/evaluacion/grafica_2/{programa}', [EvaluacionCurricularController::class, 'grafica_2']);
    Route::get('/admin/planes_estudio/evaluacion/grafica_3/{programa}', [EvaluacionCurricularController::class, 'grafica_3']);
    //EVALUACION CURRICULAR - FIN

});
/* --------------------------
    FIN - PLANES DE ESTUDIO
    --------------------------*/
