<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\NotaController as AdminNotaController;
use App\Http\Controllers\admin\ActivityController;
use App\Http\Controllers\admin\GradeController;
use App\Http\Controllers\admin\GradetypeController;
use App\Http\Controllers\admin\IndicatorController;
use App\Http\Controllers\admin\SubjectenrollmentController;

/* --------------------------
    INICIO - NOTAS
--------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin,teacher']], function () {

  Route::get('/admin/notas/notas_asignaturas', [AdminNotaController::class, 'index1'])->name('admin.notas.notas_asignaturas');
  Route::post('/admin/notas/list_nota_asignatura', [AdminNotaController::class, 'list_nota_asignatura']);
  Route::post('/admin/notas/list_detalle_nota', [AdminNotaController::class, 'list_detalle_nota']);

  Route::get('/admin/notas/notas_alumnos', [AdminNotaController::class, 'index2'])->name('admin.notas.notas_alumnos');
  Route::post('/admin/notas/list_nota_alumno', [AdminNotaController::class, 'list_nota_alumno']);

    // INICIO
    Route::post('/admin/notas/gestionar_nota/students_by_idsubject', [SubjectenrollmentController::class, 'students_by_idsubject']);
    Route::put('/admin/notas/gestionar_nota/update_nota/{id}', [SubjectenrollmentController::class, 'update_nota']);
    // FIN

    // INDICADORES - INICIO
    Route::get('/admin/notas/indicadores', [IndicatorController::class, 'index'])->name('admin.notas.indicadores');
    Route::post('/admin/notas/indicadores/list', [IndicatorController::class, 'list']);
    Route::post('/admin/notas/indicadores/store', [IndicatorController::class, 'store']);
    Route::put('/admin/notas/indicadores/update/{id}', [IndicatorController::class, 'update']);
    Route::delete('/admin/notas/indicadores/destroy/{id}', [IndicatorController::class, 'destroy']);
    // INDICADORES - FIN

    // ACTIVIDADES - INICIO
    Route::post('/admin/notas/actividades/list', [ActivityController::class, 'list']);
    Route::post('/admin/notas/actividades/store', [ActivityController::class, 'store']);
    Route::put('/admin/notas/actividades/update/{id}', [ActivityController::class, 'update']);
    Route::delete('/admin/notas/actividades/destroy/{id}', [ActivityController::class, 'destroy']);
    // ACTIVIDADES - FIN

    // NOTAS - INICIO
    Route::post('/admin/notas/notas/list', [GradeController::class, 'list']);
    Route::post('/admin/notas/notas/store', [GradeController::class, 'store']);
    Route::put('/admin/notas/notas/update/{id}', [GradeController::class, 'update']);
    Route::delete('/admin/notas/notas/destroy/{id}', [GradeController::class, 'destroy']);
    // NOTAS - FIN

    // TIPOS NOTAS - INICIO
    Route::get('/admin/notas/tipos_notas', [GradetypeController::class, 'index'])->name('admin.notas.tipos_notas');
    Route::get('/admin/notas/tipos_notas/list', [GradetypeController::class, 'list']);
    Route::post('/admin/notas/tipos_notas/store', [GradetypeController::class, 'store']);
    Route::put('/admin/notas/tipos_notas/update/{id}', [GradetypeController::class, 'update']);
    Route::delete('/admin/notas/tipos_notas/destroy/{id}', [GradetypeController::class, 'destroy']);
    // TIPOS NOTAS - FIN

});
/* --------------------------
        FIN - NOTAS
        --------------------------*/
