<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\SemesterenrollmentController;
use App\Http\Controllers\admin\StudentdocumentController;
use App\Http\Controllers\admin\SubjectenrollmentController;
use App\Http\Controllers\FileController;

/* --------------------------
    INICIO - MATRICULA
    --------------------------*/

    Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:matricula']], function () {
      // ALUMNOS_SEMESTRE - INICIO
      Route::get('/admin/matricula/alumnos_semestre', [SemesterenrollmentController::class, 'index'])->name('admin.matricula.alumnos_semestre');
      Route::post('/admin/matricula/alumnos_semestre/list', [SemesterenrollmentController::class, 'list']);
      Route::post('/admin/matricula/alumnos_semestre/list_courses_by_student', [SemesterenrollmentController::class, 'list_courses_by_student']);
      Route::post('/admin/matricula/alumnos_semestre/list_courses_by_student_for_enrollment', [SemesterenrollmentController::class, 'list_courses_by_student_for_enrollment']);
      Route::post('/admin/matricula/alumnos_semestre/store', [SemesterenrollmentController::class, 'store']);
      Route::post('/admin/matricula/alumnos_semestre/update/{idsemesterenrollment}', [SemesterenrollmentController::class, 'update']);
      Route::delete('/admin/matricula/alumnos_semestre/destroy/{id}', [SemesterenrollmentController::class, 'destroy']);
      Route::get('/verBoucherMatricula/{idstudent}/{idsemesterenrollment}', [FileController::class, 'verBoucherMatricula']);
      // ALUMNOS_SEMESTRE - FIN


      // ALUMNOS_CURSOS - INICIO
      Route::get('/admin/matricula/alumnos_cursos', [SubjectenrollmentController::class, 'index'])->name('admin.matricula.alumnos_cursos');
      Route::post('/admin/matricula/alumnos_cursos/list', [SubjectenrollmentController::class, 'list']);
      Route::post('/admin/matricula/alumnos_cursos/list_not_enrollment_subjects', [SubjectenrollmentController::class, 'list_not_enrollment_subjects']);
      Route::post('/admin/matricula/alumnos_cursos/store', [SubjectenrollmentController::class, 'store']);
      Route::get('/admin/matricula/alumnos_cursos/update_estado/{id}', [SubjectenrollmentController::class, 'update_estado']);
      Route::delete('/admin/matricula/alumnos_cursos/destroy/{id}', [SubjectenrollmentController::class, 'destroy']);
      Route::post('/admin/matricula/alumnos_cursos/list_historial', [SubjectenrollmentController::class, 'list_historial']);
      // ALUMNOS_CURSOS - FIN


      // RESERVAS_LICENCIAS - INICIO
      Route::get('/admin/matricula/reservas_licencias', [StudentdocumentController::class, 'index'])->name('admin.matricula.reservas_licencias');
      Route::post('/admin/matricula/reservas_licencias/list', [StudentdocumentController::class, 'list']);
      Route::post('/admin/matricula/reservas_licencias/store', [StudentdocumentController::class, 'store']);
      Route::post('/admin/matricula/reservas_licencias/update/{idstudentdocument}', [StudentdocumentController::class, 'update']);
      Route::put('/admin/matricula/reservas_licencias/update/estado/{idstudentdocument}', [StudentdocumentController::class, 'updateestado']);
      Route::delete('/admin/matricula/reservas_licencias/destroy/{idstudentdocument}', [StudentdocumentController::class, 'destroy']);
      Route::get('/verDocumentoEstudiante/{idstudent}/{idstudentdocument}', [FileController::class, 'verDocumentoEstudiante']);
      // RESERVAS_LICENCIAS - FIN
  });
  /* --------------------------
          FIN - MATRICULA
          --------------------------*/
