<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\AreaController;
use App\Http\Controllers\admin\ClassroomController;
use App\Http\Controllers\admin\IdentificationtypeController;
use App\Http\Controllers\admin\ProgramController;
use App\Http\Controllers\admin\RoleAreaController;
use App\Http\Controllers\admin\SemesterController;
use App\Http\Controllers\admin\TdEstadoController;
use App\Http\Controllers\admin\TdTipoController;
use App\Http\Controllers\admin\TeachercontracttypeController;
use App\Http\Controllers\admin\TeachertypeController;
use App\Http\Controllers\admin\TeacherRequirementController;
use App\Http\Controllers\admin\TeacherDocumentController;
use App\Http\Controllers\admin\AgreementEfsrtController;
use App\Http\Controllers\admin\TdTipoSolicitanteController;
use BaconQrCodeTest\Common\FormatInformationTest;
use App\Http\Controllers\admin\InfoInstitucionalController;
use App\Http\Controllers\admin\CampusController;
use App\Http\Controllers\admin\ParametroAcademicoController;
use App\Http\Controllers\admin\InstitutionController;
use App\Models\Institutes;

/* --------------------------
    INICIO - INSTITUCION
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:institucion']], function () {
    // PROGRAMAS - INICIO
    Route::get('/admin/institucion/programas', [ProgramController::class, 'index'])->name('admin.institucion.programas');
    Route::get('/admin/institucion/programas/list/proftec', [ProgramController::class, 'listproftec'])->name('admin.institucion.programas.list.prof.tec');
    Route::get('/admin/institucion/programas/list/tec', [ProgramController::class, 'listtec'])->name('admin.institucion.programas.list.tec');
    Route::get('/admin/cargar/catalogo/programas/proftec', [ProgramController::class, 'cargarExcelproftec'])->name('admin.cargar.catalogo.programas.proftec');
    Route::get('/admin/cargar/catalogo/programas/tec', [ProgramController::class, 'cargarExceltec'])->name('admin.cargar.catalogo.programas.tec');
    Route::post('/post-programas', [ProgramController::class, 'store'])->name('admin.institucion.programas.store');
    Route::delete('/delete-programas/{id}', [ProgramController::class, 'destroy'])->name('elementos.eliminar');
    // PROGRAMAS - FIN


    // AULAS - INICIO
    Route::get('/admin/institucion/aulas', [ClassroomController::class, 'index'])->name('admin.institucion.aulas');
    Route::get('/admin/institucion/aulas/list', [ClassroomController::class, 'list']);
    Route::post('/admin/institucion/aulas/store', [ClassroomController::class, 'store']);
    Route::put('/admin/institucion/aulas/update/{id}', [ClassroomController::class, 'update']);
    Route::delete('/admin/institucion/aulas/destroy/{id}', [ClassroomController::class, 'destroy']);
    // AULAS - FIN


    // PERIODOS LECTIVOS - INICIO
    Route::get('/admin/institucion/semestres', [SemesterController::class, 'index'])->name('admin.institucion.semestres');
    Route::get('/admin/institucion/semestres/list', [SemesterController::class, 'list']);
    Route::post('/admin/institucion/semestres/store', [SemesterController::class, 'store']);
    Route::put('/admin/institucion/semestres/update/{id}', [SemesterController::class, 'update']);
    Route::put('/admin/institucion/semestres/update_estado/{id}', [SemesterController::class, 'update_estado']);
    Route::delete('/admin/institucion/semestres/destroy/{id}', [SemesterController::class, 'destroy']);
    // PERIODOS LECTIVOS - FIN


    // TIPO DE DOCENTE - INICIO
    Route::get('/admin/institucion/tiposdocente', [TeachertypeController::class, 'index'])->name('admin.institucion.tiposdocente');
    Route::post('/admin/institucion/tiposdocente/list', [TeachertypeController::class, 'list']);
    Route::post('/admin/institucion/tiposdocente/store', [TeachertypeController::class, 'store']);
    Route::put('/admin/institucion/tiposdocente/update/{id}', [TeachertypeController::class, 'update']);
    Route::delete('/admin/institucion/tiposdocente/destroy/{id}', [TeachertypeController::class, 'destroy']);
    // TIPO DE DOCENTE - FIN


    // REQUISITOS DE DOCENTE - INICIO
    Route::get('/admin/institucion/requisitosdocente', [TeacherRequirementController::class, 'index'])->name('admin.institucion.requisitosdocente');
    Route::post('/admin/institucion/requisitosdocente/list', [TeacherRequirementController::class, 'list']);
    Route::post('/admin/institucion/requisitosdocente/store', [TeacherRequirementController::class, 'store']);
    Route::put('/admin/institucion/requisitosdocente/update/{id}', [TeacherRequirementController::class, 'update']);
    Route::delete('/admin/institucion/requisitosdocente/destroy/{id}', [TeacherRequirementController::class, 'destroy']);
    // REQUISITOS DE DOCENTE - FIN


    // DOCUMENTOS DE DOCENTE - INICIO
    Route::post('/admin/institucion/documentosdocente/list', [TeacherDocumentController::class, 'list']);
    Route::put('/admin/institucion/documentosdocente/update/{id}', [TeacherDocumentController::class, 'update']);
    Route::delete('/admin/institucion/documentosdocente/destroy/{id}', [TeacherDocumentController::class, 'destroy']);
    Route::get('/verDocumentoRequisito/{id}', [TeacherDocumentController::class, 'verDocumentoRequisito']);
    // DOCUMENTOS DE DOCENTE - FIN


    // TIPO DE IDENTIFICACION - INICIO
    Route::get('/admin/institucion/tiposidenti', [IdentificationtypeController::class, 'index'])->name('admin.institucion.tiposidenti');
    Route::get('/admin/institucion/tiposidenti/list', [IdentificationtypeController::class, 'list']);
    Route::post('/admin/institucion/tiposidenti/store', [IdentificationtypeController::class, 'store']);
    Route::put('/admin/institucion/tiposidenti/update/{id}', [IdentificationtypeController::class, 'update']);
    Route::delete('/admin/institucion/tiposidenti/destroy/{id}', [IdentificationtypeController::class, 'destroy']);
    // TIPO DE IDENTIFICACION - FIN


    // TIPO DE CONTRATO DOCENTE - INICIO
    Route::get('/admin/institucion/tiposcontratodocente', [TeachercontracttypeController::class, 'index'])->name('admin.institucion.tiposcontratodocente');
    Route::get('/admin/institucion/tiposcontratodocente/list', [TeachercontracttypeController::class, 'list']);
    Route::post('/admin/institucion/tiposcontratodocente/store', [TeachercontracttypeController::class, 'store']);
    Route::put('/admin/institucion/tiposcontratodocente/update/{id}', [TeachercontracttypeController::class, 'update']);
    Route::delete('/admin/institucion/tiposcontratodocente/destroy/{id}', [TeachercontracttypeController::class, 'destroy']);
    // TIPO DE CONTRATO DOCENTE - FIN

    // TIPO DE TRAMITE DOCUMENTARIO - INICIO
    Route::get('/admin/institucion/td_tipos', [TdTipoController::class, 'index'])->name('admin.institucion.td_tipos');
    Route::get('/admin/institucion/td_tipos/list', [TdTipoController::class, 'list']);
    Route::post('/admin/institucion/td_tipos/store', [TdTipoController::class, 'store']);
    Route::put('/admin/institucion/td_tipos/update/{id}', [TdTipoController::class, 'update']);
    Route::delete('/admin/institucion/td_tipos/destroy/{id}', [TdTipoController::class, 'destroy']);
    // TIPO DE TRAMITE DOCUMENTARIO - FIN

    // AREAS - INICIO
    Route::get('/admin/institucion/areas', [AreaController::class, 'index'])->name('admin.institucion.areas');
    Route::get('/admin/institucion/areas/list', [AreaController::class, 'list']);
    Route::post('/admin/institucion/areas/store', [AreaController::class, 'store']);
    Route::put('/admin/institucion/areas/update/{id}', [AreaController::class, 'update']);
    Route::delete('/admin/institucion/areas/destroy/{id}', [AreaController::class, 'destroy']);
    // AREAS - FIN

    // ESTADO DE TRAMITE DOCUMENTARIO - INICIO
    Route::get('/admin/institucion/td_estados', [TdEstadoController::class, 'index'])->name('admin.institucion.td_estados');
    Route::get('/admin/institucion/td_estados/list', [TdEstadoController::class, 'list']);
    Route::post('/admin/institucion/td_estados/store', [TdEstadoController::class, 'store']);
    Route::put('/admin/institucion/td_estados/update/{id}', [TdEstadoController::class, 'update']);
    Route::delete('/admin/institucion/td_estados/destroy/{id}', [TdEstadoController::class, 'destroy']);
    // ESTADO DE TRAMITE DOCUMENTARIO - FIN

    // ROLES Y AREAS - INICIO
    Route::get('/admin/institucion/roles_areas', [RoleAreaController::class, 'index'])->name('admin.institucion.roles_areas');
    Route::get('/admin/institucion/roles_areas/list', [RoleAreaController::class, 'list']);
    Route::post('/admin/institucion/roles_areas/store', [RoleAreaController::class, 'store']); // query params
    Route::delete('/admin/institucion/roles_areas/destroy', [RoleAreaController::class, 'destroy']); // query params
    // ROLES Y AREAS - FIN

    // CONVENIOS - INICIO
    Route::get('/admin/institucion/convenios', [AgreementEfsrtController::class, 'index'])->name('admin.institucion.convenios');
    Route::get('/admin/institucion/convenios/list', [AgreementEfsrtController::class, 'list']);
    Route::post('/admin/institucion/convenios/store', [AgreementEfsrtController::class, 'store']);
    Route::post('/admin/institucion/convenios/update/{id}', [AgreementEfsrtController::class, 'update']);
    Route::delete('/admin/institucion/convenios/destroy/{id}', [AgreementEfsrtController::class, 'destroy']);
    // CONVENIOS - FIN

    // TIPOS SOLICITANTES - INICIO
    Route::get('/admin/institucion/td_tipos_solicitantes', [TdTipoSolicitanteController::class, 'index'])->name('admin.institucion.td_tipos_solicitantes');
    Route::get('/admin/institucion/td_tipos_solicitantes/list', [TdTipoSolicitanteController::class, 'list']);
    Route::post('/admin/institucion/td_tipos_solicitantes/store', [TdTipoSolicitanteController::class, 'store']);
    Route::put('/admin/institucion/td_tipos_solicitantes/update/{id}', [TdTipoSolicitanteController::class, 'update']);
    Route::delete('/admin/institucion/td_tipos_solicitantes/destroy/{id}', [TdTipoSolicitanteController::class, 'destroy']);
    // TIPOS SOLICITANTES - FIN

    //INFORMACION INSTITUCIONAL - INICIO
    Route::get('/admin/institucion/info_institucional', [InfoInstitucionalController::class, 'index'])->name('admin.institucion.info_institucional');
    Route::get('/admin/institucion/info_institucional/list', [InfoInstitucionalController::class, 'list']);
    Route::put('/admin/institucion/info_institucional/update/1', [InfoInstitucionalController::class, 'update']);
    Route::get('/admin/institucion/logo/{file}', [InfoInstitucionalController::class, 'verLogo'])
        ->name('admin.institucion.logo')
        ->where('file', '.*');
    //INFORMACION INSTITUCIONAL - FIN

    // SEDES - INICIO
    Route::get('/admin/institucion/sedes', [CampusController::class, 'index'])->name('admin.institucion.sedes');
    Route::get('/admin/institucion/sedes/list', [CampusController::class, 'list']);
    Route::post('/admin/institucion/sedes/store', [CampusController::class, 'store']);
    Route::put('/admin/institucion/sedes/update/{id}', [CampusController::class, 'update']);
    Route::delete('/admin/institucion/sedes/destroy/{id}', [CampusController::class, 'destroy']);
    // SEDES - FIN

    // INSTITUTOS - INICIO
    Route::get('/admin/institucion/instituciones', [InstitutionController::class, 'index'])->name('admin.institucion.instituciones');
    Route::get('/admin/institucion/instituciones/list', [InstitutionController::class, 'list']);
    Route::post('/admin/institucion/instituciones/store', [InstitutionController::class, 'store']);
    Route::put('/admin/institucion/instituciones/update/{id}', [InstitutionController::class, 'update']);
    Route::delete('/admin/institucion/instituciones/destroy/{id}', [InstitutionController::class, 'destroy']);
    // INSTITUTOS - FIN

    // PARAMETROS ACADEMICOS - INICIO
    Route::prefix('/admin/institucion/parametros_academicos')->group(function () {

        Route::middleware(['module:institucion'])->group(function () {
            Route::get('', [ParametroAcademicoController::class, 'index'])->name('admin.institucion.parametros_academicos');
            Route::get('/list', [ParametroAcademicoController::class, 'list'])->middleware('action:read');
            Route::post('/store', [ParametroAcademicoController::class, 'store'])->middleware('action:create');
            Route::put('/update/{id}', [ParametroAcademicoController::class, 'update'])->middleware('action:update');
            Route::delete('/destroy/{id}', [ParametroAcademicoController::class, 'destroy'])->middleware('action:delete');
        });
    });
    // PARAMETROS ACADEMICOS - FIN
});
/* --------------------------
    FIN - INSTITUCION
    --------------------------*/
