<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\ScheduleController;
use App\Http\Controllers\admin\AttendanceController;

Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin', 'module:horarios']], function () {
  // HORARIOS - INICIO
  Route::get('/admin/horarios/asignar_horario', [ScheduleController::class, 'index'])->name('admin.horarios.asignar_horario');
  Route::post('/admin/horarios/asignar_horario/list', [ScheduleController::class, 'list']);
  Route::post('/admin/horarios/asignar_horario/list2', [ScheduleController::class, 'list2']);
  Route::post('/admin/horarios/asignar_horario/store', [ScheduleController::class, 'store']);
  Route::put('/admin/horarios/asignar_horario/update/{id}', [ScheduleController::class, 'update']);
  Route::delete('/admin/horarios/asignar_horario/destroy/{id}', [ScheduleController::class, 'destroy']);
  Route::get('/admin/horarios/horario_general', [ScheduleController::class, 'index2'])->name('admin.horarios.horario_general');
  Route::post('/admin/horarios/horario_general/list', [ScheduleController::class, 'horario_general']);
  Route::post('/admin/horarios/horario_general/generar_horario/{idsemester}', [ScheduleController::class, 'generar_horario']);
  Route::get('/admin/horarios/horario_docente', [ScheduleController::class, 'index3'])->name('admin.horarios.horario_docente');
  Route::post('/admin/horarios/horario_docente/list', [ScheduleController::class, 'horario_docente']);
  Route::get('/admin/horarios/horario_estudiante', [ScheduleController::class, 'index4'])->name('admin.horarios.horario_estudiante');
  Route::post('/admin/horarios/horario_estudiante/list', [ScheduleController::class, 'horario_estudiante']);
  Route::get('/admin/horarios/periodo_examen', [ScheduleController::class, 'index5'])->name('admin.horarios.periodo_examen');
  Route::post('/admin/horarios/periodo_examen/list', [ScheduleController::class, 'periodo_examen']);
  Route::post('/admin/horarios/horario_general/generar_clases/{idsemester}/{fecha}', [AttendanceController::class, 'generar_clases']);
  Route::post('/admin/horarios/horario_general/eliminar_clases/{idsemester}', [AttendanceController::class, 'eliminar_clases']);
  // HORARIOS - FIN
});
