<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\ExonerationController;

/* --------------------------
    INICIO - PORTAFOLIO DOCENTES
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:tesoreria']], function () {
    // DOCENTES - INICIO
    Route::get('/admin/registros_pagos/exoneraciones', [ExonerationController::class, 'index'])->name('admin.registros_pagos.exoneraciones');
    Route::post('/admin/registros_pagos/exoneraciones/list', [ExonerationController::class, 'list']);
    Route::post('/admin/registros_pagos/exoneraciones/store', [ExonerationController::class, 'store']);
    Route::put('/admin/registros_pagos/exoneraciones/update/{id}', [ExonerationController::class, 'update']);
    Route::delete('/admin/registros_pagos/exoneraciones/destroy/{id}', [ExonerationController::class, 'destroy']);
    Route::get('/admin/registros_pagos/exoneraciones/view_document/{id}', [ExonerationController::class, 'viewDocument'])->name('admin.exoneraciones.view_document');
});
/* --------------------------
    FIN - PORTAFOLIO DOCENTES
    --------------------------*/
