<?php

use App\Http\Controllers\admin\ConvalidationsController;
use App\Http\Controllers\admin\DownloadExcelplantillaStudentsController;
use App\Http\Controllers\admin\InscripcionesstudentsController;
use App\Http\Controllers\admin\StudentController;
use App\Http\Controllers\admin\TransfersController;
use Illuminate\Support\Facades\Route;

/* --------------------------
    INICIO - INSCRIPCIÓN ESTUDIANTES
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin']], function () {
    // GESTIONAR ESTUDIANTES - INICIO
    Route::get('/admin/incripciones/students', [InscripcionesstudentsController::class, 'index'])->name('admin.incripcion.students');
    Route::get('/admin/programs/list/', [InscripcionesstudentsController::class, 'list'])->name('admin.programs.list');
    Route::get('/admin/inscripciones/programs/list_plans/{idprogram}', [InscripcionesstudentsController::class, 'listplans']);
    Route::get('/admin/inscripciones/students/list', [InscripcionesstudentsController::class, 'liststudents'])->name('admin.inscripciones.students.list');
    Route::post('/admin/incripciones/students/plantilla/download', [DownloadExcelplantillaStudentsController::class, 'downloadExcelFile'])->name('inscripcion.students.plantilla.download');
    Route::post('/admin/inscripciones/students/storePlantilla', [InscripcionesstudentsController::class, 'store_plantilla']);

    Route::post('/admin/inscripciones/students/store', [StudentController::class, 'store']);
    Route::put('/admin/inscripciones/students/update/{id}', [StudentController::class, 'update']);
    Route::put('/admin/inscripciones/students/update_password/{id}', [StudentController::class, 'update_password']);
    Route::put('/admin/inscripciones/students/update_plan/{id}', [StudentController::class, 'update_plan']);
    Route::delete('/admin/inscripciones/students/destroy/{id}', [StudentController::class, 'destroy']);
    // GESTIONAR ESTUDIANTES - FIN

    // TRASLADOS - INICIO
    Route::get('/admin/estudiantes/traslados/', [TransfersController::class, 'index'])->name('admin.estudiantes.traslados');
    Route::post('/admin/estudiantes/traslados/list', [TransfersController::class, 'list']);
    Route::get('/admin/estudiantes/traslados/get-local-institution', [TransfersController::class, 'getLocalInstitution']);
    Route::get('/admin/estudiantes/traslados/get-external-institutions', [TransfersController::class, 'getExternalInstitutions']);
    Route::post('/admin/estudiantes/buscar', [TransfersController::class, 'searchStudent'])->name('admin.estudiantes.buscar');
    Route::get('/admin/estudiantes/traslados/show/{id}', [TransfersController::class, 'show']);
    Route::post('/admin/estudiantes/traslados/update/{id}', [TransfersController::class, 'update']);
    Route::post('/admin/estudiantes/traslados/store', [TransfersController::class, 'store']);
    Route::get('/admin/estudiantes/traslados/ver/{file}', [TransfersController::class, 'verDocumento'])
        ->where('file', '.*');
    Route::delete('/admin/estudiantes/traslados/destroy/{id}', [TransfersController::class, 'destroy']);
    // TRASLADOS - FIN

    //CONVALIDACIONES - INICIO
    Route::get('/admin/estudiantes/convalidaciones/', [ConvalidationsController::class, 'index'])->name('admin.estudiantes.convalidaciones');
    Route::get('/admin/estudiantes/convalidaciones/listar', [ConvalidationsController::class, 'listar']);
    Route::post('/admin/estudiantes/convalidaciones/store', [ConvalidationsController::class, 'store']);
    Route::post('/admin/estudiantes/convalidaciones/cursos/store', [ConvalidationsController::class, 'storeCourseEquivalence']);
    Route::get('/admin/estudiantes/convalidaciones/cursos/list/{id}', [ConvalidationsController::class, 'listCourseEquivalences']);
    Route::delete('/admin/estudiantes/convalidaciones/cursos/destroy/{id}', [ConvalidationsController::class, 'destroyCourseEquivalence']);
    Route::get('/admin/estudiantes/convalidaciones/documento/{file}', [ConvalidationsController::class, 'verDocumento'])->where('file', '.*')->name('documentos');
    Route::delete('/admin/estudiantes/convalidaciones/destroy/{id}', [ConvalidationsController::class, 'destroyConvalidacion']);

    Route::prefix('ajax_all')->group(function () {
        Route::get('/programs', [ConvalidationsController::class, 'ajaxPrograms']);
        Route::get('/plans/by_program/{idprogram}', [ConvalidationsController::class, 'ajaxPlansByProgram']);
        Route::get('/students', [ConvalidationsController::class, 'ajaxStudents']);

        Route::get('/student/by_idprograms/{idprogram}', [ConvalidationsController::class, 'studentByProgram']);
        Route::get('/student/by_program_plan/{idprogram}/{idplan}', [ConvalidationsController::class, 'studentByProgramPlan']);
        Route::get('/institutions', [ConvalidationsController::class, 'ajaxInstitutions']);
        Route::get('/cursos/by_plan/{idplan}', [ConvalidationsController::class, 'ajaxCursosByPlan']);
    });
    //CONVALIDACIONES - FIN
});
/* --------------------------
    FIN - INSCRIPCIÓN ESTUDIANTES
    --------------------------*/
