<?php

use App\Http\Controllers\EfsrtController;
use Illuminate\Support\Facades\Route;

// API

Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin', 'module:efsrt']], function () {
    Route::prefix('/api/efsrt')->group(
        function () {
            Route::get('/test', [EfsrtController::class, 'listWithDetails']);
            Route::post('/', [EfsrtController::class, 'store']);
            Route::post('/detail', [EfsrtController::class, 'store_detail']);
            Route::delete('/{id}', [EfsrtController::class, 'destroy']);
            
            // For datatables
            Route::post('/list', [EfsrtController::class, 'dt_list']);
            Route::post('/list/details', [EfsrtController::class, 'dt_listWithDetails']);
            
            // Route::get('/{id}', [EfsrtController::class, 'findOne']);
            Route::get('/{id}/details', [EfsrtController::class, 'findOneWithDetails']);
            // Route::get('/nro_documento/{nro_documento}', [EfsrtController::class, 'findOneByNroDocumento']);
            Route::put('/{id}/disable', [EfsrtController::class, 'disableEfsrtDetalle']);
            Route::put('/{id}/enable', [EfsrtController::class, 'enableEfsrtDetalle']);
            Route::delete('/{id}/detail', [EfsrtController::class, 'destroyEfsrtDetalle']);
            Route::delete('/{id}', [EfsrtController::class, 'destroyEfsrt']);
        }
    );

    // WEB
    Route::prefix('/efsrt')->group(
        function () {
            Route::get('', [EfsrtController::class, 'index'])->name('admin.efsrt.gestionar');
        }
    );
});
//supuestamente la ruta seria aqui ojo revisar
