<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\TeacherController;

/* --------------------------
    INICIO - PORTAFOLIO DOCENTES
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:docentes']], function () {
    // DOCENTES - INICIO
    Route::get('/admin/portafolio/docentes', [TeacherController::class, 'index'])->name('admin.docentes.gestionar');
    Route::post('/admin/portafolio/docentes/list', [TeacherController::class, 'list']);
    Route::post('/admin/portafolio/docentes/store', [TeacherController::class, 'store']);
    Route::put('/admin/portafolio/docentes/update/{id}', [TeacherController::class, 'update']);
    Route::put('/admin/portafolio/docentes/update_password/{id}', [TeacherController::class, 'update_password']);
    Route::put('/admin/portafolio/docentes/update_credentials_zoom/{id}', [TeacherController::class, 'update_credentials_zoom']);
    Route::delete('/admin/portafolio/docentes/destroy/{id}', [TeacherController::class, 'destroy']);
});
/* --------------------------
    FIN - PORTAFOLIO DOCENTES
    --------------------------*/
