<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\home\DashboardController;
use App\Http\Controllers\LoginController;

// DASHBOAR - USUARIO ADMINISTRADORES

Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin']], function () {
    // Aquí van las rutas que requieren autenticación
    Route::get('/home/adm', [LoginController::class, 'dashboard'])->name('home.adm.dashboard');

    //routes para el dashboard cantidadUser - INICIO
    Route::get('/home/dashboard/getStats', [DashboardController::class, 'getStats']);
    Route::get('/home/dashboard/getRecaudacionPorMes', [DashboardController::class, 'getRecaudacionPorMes']);
    Route::get('/home/dashboard/getRecaudacionPorConcepto', [DashboardController::class, 'getRecaudacionPorConcepto']);
    Route::get('/home/dashboard/getEstudiantesPrograma', [DashboardController::class, 'getEstudiantesPrograma']);
    Route::get('/home/dashboard/getEgresadosAnho', [DashboardController::class, 'getEgresadosAnho']);
    //routes para el dashboard cantidadUser - FIN
});
// FIN
