<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\admin\ConsultationController;

/* --------------------------
    INICIO - CONSTANCIAS Y CERTIFICADOS
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin,teacher,student', 'module:consultas']], function () {
    // GESTIONAR CONSTANCIAS CERTIFICADOS - INICIO
    Route::get('/admin/consulta/constancias_certificados', [ConsultationController::class, 'index'])->name('admin.consulta.constancias_certificados');
    Route::get('/admin/consulta/constancias_certificados/list_estudiantes/{idstudent}', [ConsultationController::class, 'list_estudiantes']);
    Route::post('/admin/seguimiento_egresado/record_academico/list', [ConsultationController::class, 'list_record_academico']);
    // GESTIONAR CONSTANCIAS CERTIFICADOS - FIN

    // GESTIONAR ACTAS OFICIALES - INICIO
    Route::get('/admin/consulta/actas_oficiales', [ConsultationController::class, 'index2'])->name('admin.consulta.actas_oficiales');
    Route::post('/admin/consulta/actas_oficiales/list_periodos', [ConsultationController::class, 'list_periodos']);
    Route::get('/reportes/actas_oficiales/matricula/{idsemester}/{idperiod}', [ConsultationController::class, 'acta_matricula']);
    // GESTIONAR ACTAS OFICIALES - FIN

    // GESTIONAR CONSTANCIAS CERTIFICADOS - INICIO
    Route::get('/admin/consulta/indicadores_gestion', [ConsultationController::class, 'index3'])->name('admin.consulta.indicadores_gestion');
    Route::post('/admin/consulta/indicadores_gestion/tasa_finalizacion', [ConsultationController::class, 'tasa_finalizacion']);
    Route::post('/admin/consulta/indicadores_gestion/tasa_abandono', [ConsultationController::class, 'tasa_abandono']);
    // GESTIONAR CONSTANCIAS CERTIFICADOS - FIN

    // GESTIONAR PRIMEROS PUESTOS - INICIO
    Route::get('/admin/consulta/primeros_puestos', [ConsultationController::class, 'index4'])->name('admin.consulta.primeros_puestos');
    Route::post('/admin/consulta/primeros_puestos/list', [ConsultationController::class, 'list_primeros_puestos']);
    // GESTIONAR PRIMEROS PUESTOS - FIN
});
/* --------------------------
    FIN - CONSTANCIAS Y CERTIFICADOS
    --------------------------*/
