<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\ActividadesCnlController;

/* --------------------------
    INICIO - PORTAFOLIO DOCENTES
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:docentes']], function () {
    // DOCENTES - INICIO
    Route::get('/admin/detalle/carga_nl/docente/{id_cnl}', [ActividadesCnlController::class, 'list']);
    Route::get('/admin/detalle/carga_nl/docente/update/{id_cnl}', [ActividadesCnlController::class, 'list_update']);

    Route::post('/admin/carga_nl/docente/store', [ActividadesCnlController::class, 'store']);
    Route::put('/admin/portafolio/docentes/update/actividades_ncl/{idregistro}', [ActividadesCnlController::class, 'update_actividades_cnl']);

    Route::delete('/admin/carga_nl/docente/destroy_acnl/{idregistro}', [ActividadesCnlController::class, 'destroy_acnl']);
    Route::delete('/admin/carga_nl/docente/destroy_dacnl/{idregistro}', [ActividadesCnlController::class, 'destroy_dacnl']);

});
  /* --------------------------
      FIN - PORTAFOLIO DOCENTES
      --------------------------*/
