<?php

use App\Http\Controllers\admin\CategoryTagController;
use App\Http\Controllers\admin\JpcategoryController;
use App\Http\Controllers\admin\JpcompanyController;
use App\Http\Controllers\admin\JpjobapplicationController;
use App\Http\Controllers\admin\JpjobController;
use App\Http\Controllers\admin\JptagController;
use App\Http\Controllers\FileController;
use Illuminate\Support\Facades\Route;

/* --------------------------
    INICIO - BOLSA LABORAL
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin,teacher,student']], function () {

    // EMPRESAS - INICIO
    Route::get('/admin/bolsa_laboral/empresas', [JpcompanyController::class, 'index'])->name('admin.bolsa_laboral.empresas');
    Route::post('/admin/bolsa_laboral/empresas/list', [JpcompanyController::class, 'list']);
    Route::post('/admin/bolsa_laboral/empresas/store', [JpcompanyController::class, 'store']);
    Route::put('/admin/bolsa_laboral/empresas/update/{id}', [JpcompanyController::class, 'update']);
    Route::put('/admin/bolsa_laboral/empresas/update_password/{id}', [JpcompanyController::class, 'update_password']);
    Route::delete('/admin/bolsa_laboral/empresas/destroy/{id}', [JpcompanyController::class, 'destroy']);
    Route::get('/admin/bolsa_laboral/empresas/query_data/{nroruc}', [JpcompanyController::class, 'query_data']); //Traer Datos del DNI
    // EMPRESAS - INICIO

    // CATEGORIAS Y ETIQUETAS - INICIO
    Route::get('/admin/bolsa_laboral/categorias_etiquetas', [CategoryTagController::class, 'index'])->name('admin.bolsa_laboral.categorias_etiquetas');
    // CATEGORIAS Y ETIQUETAS - FIN

    // CATEGORIAS - INICIO
    Route::post('/admin/bolsa_laboral/categorias/list', [JpcategoryController::class, 'list']);
    Route::post('/admin/bolsa_laboral/categorias/store', [JpcategoryController::class, 'store']);
    Route::put('/admin/bolsa_laboral/categorias/update/{id}', [JpcategoryController::class, 'update']);
    Route::delete('/admin/bolsa_laboral/categorias/destroy/{id}', [JpcategoryController::class, 'destroy']);
    // CATEGORIAS - INICIO

    // ETIQUETAS - INICIO
    Route::post('/admin/bolsa_laboral/etiquetas/list', [JptagController::class, 'list']);
    Route::post('/admin/bolsa_laboral/etiquetas/store', [JptagController::class, 'store']);
    Route::put('/admin/bolsa_laboral/etiquetas/update/{id}', [JptagController::class, 'update']);
    Route::delete('/admin/bolsa_laboral/etiquetas/destroy/{id}', [JptagController::class, 'destroy']);
    // ETIQUETAS - INICIO

    // OFERTAS LABORALES - INICIO
    Route::get('/admin/bolsa_laboral/ofertas_laborales', [JpjobController::class, 'index'])->name('admin.bolsa_laboral.ofertas_laborales');
    Route::post('/admin/bolsa_laboral/ofertas_laborales/list', [JpjobController::class, 'list']);
    Route::post('/admin/bolsa_laboral/ofertas_laborales/store', [JpjobController::class, 'store']);
    Route::put('/admin/bolsa_laboral/ofertas_laborales/update/{id}', [JpjobController::class, 'update']);
    Route::delete('/admin/bolsa_laboral/ofertas_laborales/destroy/{id}', [JpjobController::class, 'destroy']);
    // OFERTAS LABORALES - FIN

    // POSTULACIONES - INICIO
    Route::get('/admin/bolsa_laboral/postulaciones', [JpjobapplicationController::class, 'index'])->name('admin.bolsa_laboral.postulaciones');
    Route::post('/admin/bolsa_laboral/postulaciones/list', [JpjobapplicationController::class, 'list']);
    Route::put('/admin/bolsa_laboral/postulaciones/aprobar/{id}', [JpjobapplicationController::class, 'aprobar']);
    Route::put('/admin/bolsa_laboral/postulaciones/rechazar/{id}', [JpjobapplicationController::class, 'rechazar']);
    Route::delete('/admin/bolsa_laboral/postulaciones/destroy/{id}', [JpjobapplicationController::class, 'destroy']);
    Route::get('/verCurriculumVitae/{idjobapplication}', [FileController::class, 'verCurriculumVitae']);
    // POSTULACIONES - FIN
});
/* --------------------------
    FIN - BOLSA LABORAL
    --------------------------*/
