<?php

use App\Http\Controllers\admin\PreguntayRespuestaController;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\PublicacionesController;
use App\Http\Controllers\admin\EncuestaController;


/* --------------------------
    INICIO - BIENESTAR INSTITUCION
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin']], function () {
  // PUBLICACIONES - INICIO
  Route::get('/admin/institucion/bienestar/publicaciones', [PublicacionesController::class, 'index'])->name('admin.institucion.bienestar.publicaciones');
  Route::get('/institucion/bienestar/publicaciones/list', [PublicacionesController::class, 'list']);
  Route::get('/institucion/bienestar/publicaciones/list/{opcion}', [PublicacionesController::class, 'list_parameter']);
  Route::post('/institucion/bienestar/publicaciones/store', [PublicacionesController::class, 'store']);
  Route::delete('/institucion/bienestar/publicaciones/destroy/{idPublicacion}', [PublicacionesController::class, 'destroy']);
  Route::get('/publicaciones/viewimg/{idpublicacion}/{carpeta}/{imagen}', [PublicacionesController::class, 'verImagen']);
  Route::put('/institucion/bienestar/publicaciones/update/{idPublicacion}', [PublicacionesController::class, 'update']);
  // FIN



  // ENCUESTAS - INICIO
  Route::get('/admin/institucion/bienestar/encuestas', [EncuestaController::class, 'index'])->name('admin.institucion.bienestar.encuestas');
  Route::get('/institucion/bienestar/encuestas/list/{opcion}', [EncuestaController::class, 'list']);
  Route::post('/institucion/bienestar/encuestas/store', [EncuestaController::class, 'store']);
  Route::delete('/institucion/bienestar/encuestas/destroy/{idPublicacion}', [EncuestaController::class, 'destroy']);
  Route::put('/institucion/bienestar/encuestas/update/{idPublicacion}', [EncuestaController::class, 'update']);


   //SEGUNDA PARTE DONDE SE CONFIGURA LAS PREGUNTAS DE LA ENCUESTA
  Route::get('/admin/institucion/bienestar/encuestas/questions/{idencuesta}', [PreguntayRespuestaController::class, 'index'])->name('admin.institucion.bienestar.encuestas.questions');
  Route::post('/institucion/bienestar/encuestas/questions/store', [PreguntayRespuestaController::class, 'store']);
  Route::get('/institucion/bienestar/encuestas/questions/list/{idencuesta}', [PreguntayRespuestaController::class, 'list']);
  Route::delete('/institucion/bienestar/encuestas/questions/destroy/{idPregunta}', [PreguntayRespuestaController::class, 'destroy']);
  Route::delete('/institucion/bienestar/encuestas/questions/opcion/destroy/{idPregunta}/{idopcion}', [PreguntayRespuestaController::class, 'destroyOpcion']);
  Route::put('/institucion/bienestar/encuestas/questions/option/update/{PreuntaoOpcion}/{idpreguntaoOpcion}', [PreguntayRespuestaController::class, 'update']);



  // FIN
});
/* --------------------------
    FIN - INSTITUCION
    --------------------------*/
