<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\admin\AdmissionController;
use App\Http\Controllers\admin\AdmissionplanController;
use App\Http\Controllers\admin\PostulantesController;
use App\Http\Controllers\FileController;

/* --------------------------
    INICIO - ADMISIÓN
    --------------------------*/
    Route::group(['middleware' => ['checksession', 'checkestado',  'role:admin', 'module:admision']], function () {

      // ADMISIONES - INICIO
        Route::get('/admin/admision/admisiones', [AdmissionController::class, 'index'])->name('admin.admision.admisiones');
        Route::post('/admin/admision/admisiones/list', [AdmissionController::class, 'list']);
        Route::post('/admin/admision/admisiones/store', [AdmissionController::class, 'store']);
        Route::put('/admin/admision/admisiones/update/{id}', [AdmissionController::class, 'update']);
        Route::delete('/admin/admision/admisiones/destroy/{id}', [AdmissionController::class, 'destroy']);
        Route::post('/admin/admision/admisiones/statistics', [AdmissionController::class, 'statistics']);
        Route::post('/admin/admision/admisiones/store_admissionplan/{idadmission}', [AdmissionplanController::class, 'store']);
        Route::put('/admin/admision/admisiones/update_admissionplan/{id}', [AdmissionplanController::class, 'update']);
        Route::delete('/admin/admision/admisiones/destroy_admissionplan/{id}', [AdmissionplanController::class, 'destroy']);
        Route::get('/admin/admision/admisiones/informacion/{id}', [AdmissionController::class, 'getInformation']);
        // ADMISIONES - FIN

        // POSTULANTES - INICIO
        Route::get('/admin/admision/postulantes', [PostulantesController::class, 'index'])->name('admin.admision.postulantes');
        Route::get('/admin/admision/postulantes/list', [PostulantesController::class, 'liststapplicants'])->name('admin.admision.postulantes.list'); // lista de postulantes en el datatable
        Route::get('/admin/admision/listadmision', [PostulantesController::class, 'list_admisiones'])->name('admin.admision.listadmision'); // card 1 la lista de admisiones
        Route::get('/admin/admision/listadmissionplan/{id}', [PostulantesController::class, 'listadmissionplan'])->name('admin.admision.listadmissionplan'); // lista de planes por admision
        Route::post('/admin/inscripciones/postulantes/downloadPlantilla', [PostulantesController::class, 'downloadExcelFile']); // este descarga plantilla
        Route::post('/admin/inscripciones/postulantes/storePlantilla', [PostulantesController::class, 'store_plantilla']);  // guarda la plantilla
        Route::post('/admin/inscripciones/postulantes/store', [PostulantesController::class, 'store']);  // guarda la plantilla
        Route::post('/admin/inscripciones/postulantes/update/{idapplicant}', [PostulantesController::class, 'update']);  // guarda la plantilla
        Route::post('/admin/inscripciones/postulantes/transformApplicantToStudent', [PostulantesController::class, 'transformApplicantToStudent']);  // guarda la plantilla
        Route::put('/admin/inscripciones/postulantes/updateNota/{id}', [PostulantesController::class, 'updateNota']);  // actualizar datos
        Route::delete('/admin/inscripciones/postulantes/destroy/{id}', [PostulantesController::class, 'destroyaplicants']);
        // aprobar o rechazar inscripcion
        Route::put('/admin/inscripciones/postulantes/aprobarInscripcion/{id}', [PostulantesController::class, 'aprobarInscripcion']);
        Route::put('/admin/inscripciones/postulantes/rechazarInscripcion/{id}', [PostulantesController::class, 'rechazarInscripcion']);

        // POSTULANTES - FIN
        Route::get('/verPostulanteDNI/{idapplicant}', [FileController::class, 'verPostulanteDNI']);
        Route::get('/verPostulanteCertificado/{idapplicant}', [FileController::class, 'verPostulanteCertificado']);
        Route::get('/verPostulanteBoucher/{idapplicant}', [FileController::class, 'verPostulanteBoucher']);
        Route::get('/verPostulanteDatosPersonales/{idapplicant}', [FileController::class, 'verPostulanteDatosPersonales']);
    });
    /* --------------------------
        FIN - ADMISIÓN
        --------------------------*/
