<?php

use App\Http\Controllers\admin\AdmissionController;
use App\Http\Controllers\admin\AdmissionplanController;
use App\Http\Controllers\admin\ApinetpeController;
use App\Http\Controllers\admin\IdentificationtypeController;
use App\Http\Controllers\admin\PostulantesController;
use App\Http\Controllers\admin\SemesterenrollmentController;
use App\Http\Controllers\admin\UbigeoController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\egresados\Datosegresado;
use App\Http\Controllers\error\ErrorController;
use App\Http\Controllers\home\DocentehomeController;
use App\Http\Controllers\home\StudenthomeController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\LoginMicrosoftController;
use App\Http\Controllers\MoodleController;
use App\Http\Controllers\reportes\ReportesController;
use App\Http\Controllers\admin\InfoInstitucionalController;
use App\Models\User;
use Illuminate\Support\Facades\Route;
use Laravel\Socialite\Facades\Socialite;

Route::get('/ajax_all/identificationtypes', [IdentificationtypeController::class, 'ajax_all']);

// INICIO DEL PROGRAMA ENTRADA AL WELCOME - LOGIN
Route::middleware('guest')->group(function () {
    Route::get('/prueba', function () {
        // Recoger toda la tabla usuarios
        $users = User::all();

        // Retornar la vista con los usuarios
        return $users;
    })->name('prueba');

    Route::get('/', [LoginController::class, 'index'])->name('login');
    Route::get('/login', [LoginController::class, 'index']);

    Route::post('authenticateLogin', [LoginController::class, 'authenticateLogin'])->name('login.authenticate');
    Route::post('profileLogin', [LoginController::class, 'profileLogin']);
});
// FIN
Route::group(['middleware' => ['checksession', 'checkestado']], function () {
    Route::post('/changeLoginType/{type}', [LoginController::class, 'changeLoginType']);
});
// HOME - USUARIO DOCENTES
Route::group(['middleware' => ['checksession', 'checkestado', 'role:teacher']], function () {
    // Aquí van las rutas que requieren autenticación
    Route::get('/home/docente', [LoginController::class, 'homeDocentes'])->name('home.docente.index');
    Route::get('/home/docente/dataAsignaturas', [DocentehomeController::class, 'homeDocentesData']);
    Route::get('/home/docente/list_students', [DocentehomeController::class, 'list_students']);
    Route::get('/ajax_all/teachers/subjectclasses/{idsubject}', [DocentehomeController::class, 'ajax_all_subjectclasses']);
});
// FIN

// HOME - USUARIO ESTUDIANTES
Route::group(['middleware' => ['checksession', 'checkestado', 'role:student']], function () {
    // Aquí van las rutas que requieren autenticación
    Route::get('/home/student', [LoginController::class, 'homeStudent'])->name('home.student.index');
    Route::get('/home/student/dataAsignaturas', [StudenthomeController::class, 'homeStudentData']);
    Route::get('/home/student/list_history_cursos', [StudenthomeController::class, 'list_history_cursos']);
});
// FIN

Route::get('/login-microsoft', function () {
    return Socialite::driver('microsoft')->redirect();
});

Route::get('/microsoft-callback', [LoginMicrosoftController::class, 'login']);

//***************************************************************************************************************************************************** */
// RUTAS PARA ADMINISTRADORES

/* --------------------------
    FUNCIONES ESPECIALES PARA ADMINS
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin']], function () {
    // ADMINISTRADORES - INICIO
    Route::get('/admin/query_data/{nroidenti}', [ApinetpeController::class, 'query_data']); //Traer Datos del DNI
    Route::get('/admin/query_data_ruc/{nroidenti}', [ApinetpeController::class, 'query_data_ruc']); //Traer Datos del RUC
    Route::get('/admin/query_bd/{nroidenti}', [UserController::class, 'query_bd']); //Traer Datos del DNI
    // ADMINISTRADORES - FIN

});

//LOGIN
include 'web/login.php';

// ERRORES
include 'web/errors.php';

//NOTIFICACIONES
include 'web/notificaciones.php';

// ADMISION
include_once 'web/admin/admision.php';

// BOLSA LABORAL
include_once 'web/admin/bolsa_laboral.php';

// CONSULTAS
include_once 'web/admin/consultas.php';

// SEGUIMIENTO EGRESADO
include_once 'web/admin/seguimiento_egresado.php';

// DASHBOARD
include_once 'web/admin/dashboard.php';

// ESTUDIANTES
include_once 'web/admin/estudiantes.php';

// HORARIOS
include_once 'web/admin/horarios.php';

// HORARIOS
include_once 'web/admin/bienestar.php';

// INSTITUCION
include_once 'web/admin/institucion.php';

// MATRICULA
include_once 'web/admin/matricula.php';

// NOTAS
include_once 'web/admin/notas.php';

// PLANES DE ESTUDIO
include_once 'web/admin/planes_de_estudio.php';

// PORTAFOLIO CURSOS
include_once 'web/admin/portafolio_cursos.php';

// EFSRT
include_once 'web/admin/efsrt.php';

// PORTAFOLIO DOCENTES
include_once 'web/admin/docentes.php';

// CARGA NO LECTIVA
include_once 'web/admin/carga_no_lectiva.php';

// SEGUIMIENTO EGRESADO
include_once 'web/admin/seguimiento_egresado.php';

// SEGURIDAD
include_once 'web/admin/seguridad.php';

// TESORERIA
include_once 'web/admin/tesoreria.php';

//EXONERACIONES DE PAGO
include_once 'web/admin/exoneraciones.php';

// TRAMITE DOCUMENTARIO
include_once 'web/common/tramite_documentario.php';

// FICHA SOCIOECONOIMCA
include_once 'web/common/ficha_socioeconomica.php';

// PROFILEPROFILE
include_once 'web/common/profile.php';

// GET ALL
include_once 'web/common/get_all.php';

// REPORTES
include_once 'web/common/reportes.php';


//***************************************************************************************************************************************************** */

// RUTAS PARA DOCENTES

include_once 'web/docente/horarios.php';
include_once 'web/docente/notas.php';
include_once 'web/docente/bolsa_laboral.php';
include_once 'web/docente/asistencias.php';
include_once 'web/docente/foros.php';
include_once 'web/docente/materiales_recursos.php';
include_once 'web/docente/citas_presenciales.php';
include_once 'web/docente/zoom.php';
include_once 'web/docente/publicaciones.php';
include_once 'web/docente/requisitos.php';
include_once 'web/docente/semanas.php';

// FIN RUTAS PARA DOCENTES

//***************************************************************************************************************************************************** */

// RUTAS PARA ALUMNOS

include_once 'web/alumno/bolsa_laboral.php';
include_once 'web/alumno/bienestar.php';
include_once 'web/alumno/horarios.php';
include_once 'web/alumno/notas.php';
include_once 'web/alumno/seguimiento_egresado.php';
include_once 'web/alumno/tesoreria.php';
include_once 'web/alumno/matricula.php';
include_once 'web/alumno/asistencias.php';
include_once 'web/alumno/tarea.php';
include_once 'web/alumno/foros.php';
include_once 'web/alumno/materiales_recursos.php';
include_once 'web/alumno/publicaciones.php';

// FIN RUTAS PARA ALUMNOS

//***************************************************************************************************************************************************** */

//RUTAS PARA DIRECCIONAR A LAS PAGES DE ERRORES
Route::get('/error-403', [ErrorController::class, 'error403'])->name('page.error.403');
Route::get('/module/tramite/error-403', [ErrorController::class, 'inactivoModuloTramite'])->name('page.inactivo.tramite');
Route::get('/modulo/page/egresado', [Datosegresado::class, 'index'])->name('modulo.page.egresado');
Route::get('/modulo/page/egresado/query_data/{nroidenti}', [Datosegresado::class, 'query_data']);
Route::post('/modulo/page/egresado/store', [Datosegresado::class, 'store']);

Route::group(['middleware' => ['checksession', 'checkestado', 'role:admin']], function () {
    Route::get('/admin/gestionar_notas/', [ReportesController::class, 'index1'])->name('admin.gestionar_notas');
    Route::get('/admin/reporte_notas/', [ReportesController::class, 'index2'])->name('admin.notas.reporte_notas');
    Route::get('/reportes/nota_asignatura/{idsemester}/{idsubject}', [ReportesController::class, 'nota_asignatura']);
    Route::get('/reportes/nota_periodo/{idsemester}/{idperiod}', [ReportesController::class, 'nota_periodo']);
    Route::get('/reportes/curso_semestre_alumno/{idsemester}/{idstudent}', [ReportesController::class, 'curso_semestre_alumno']);
    Route::get('/reportes/curso_total_alumno/{idsemester}/{idstudent}', [ReportesController::class, 'curso_total_alumno']);
    Route::get('/reportes/list_egresados/{idplan}', [ReportesController::class, 'list_egresados']);
});

Route::get('/institucion/cargarLogo', [InfoInstitucionalController::class, 'cargarLogo'])->name('institucion.cargarLogo');
Route::get('/semestre/{id}/informacion', [SemesterenrollmentController::class, 'getInformacion'])->name('semestre.informacion');
Route::get('/reportes/certificado_general/{idstudent}', [ReportesController::class, 'certificado_general']);
Route::get('/reportes/certificado_modular/{idstudent}/{idmodule}', [ReportesController::class, 'certificado_modular']);
Route::get('/reportes/constancia_egresado/{idstudent}', [ReportesController::class, 'constancia_egresado']);
Route::get('/reportes/diploma_estudios/{idstudent}', [ReportesController::class, 'diploma_estudios']);
Route::get('/reportes/record_notas/{idstudent}', [ReportesController::class, 'record_notas']);
Route::get('/reportes/prueba/{idstudent}', [ReportesController::class, 'prueba']);
Route::get('/reportes/validar-certificado/{idstudent}', [ReportesController::class, 'validarCertificadoParaEmision']);
Route::get('/verificar/certificado/{code}', [ReportesController::class, 'MostrarCertificadoModular'])
    ->name('verification.show');

//***************************************************************************************************************************************************** */

/* -------------------------- INICIO - FORM POSTULANTE -------------------------- */
// index
Route::get('/admision', [AdmissionController::class, 'open_index'])->name('admision.inscripcion');

// store
Route::post('/admision/store', [PostulantesController::class, 'open_store']);

// Combo Selects
Route::get('/ajax_all/programs_online', [AdmissionController::class, 'ajax_all_admission']);
Route::get('/ajax_all/plans_online/{idadmission}/{idprogram}', [AdmissionplanController::class, 'ajax_all_admissionplans']);

// Ubigeo
Route::get('/ajax_all/ubigeo/provincias_online/{departamento}', [UbigeoController::class, 'ajax_all_ubigeo_provincias'])->name('ajax_all.ubigeo.provincias');
Route::get('/ajax_all/ubigeo/distritos_online/{provincia}', [UbigeoController::class, 'ajax_all_ubigeo_distritos'])->name('ajax_all.ubigeo.distritos');
/* --- FIN - FORM POSTULANTE --------------------------*/

Route::get('/moodle/prueba', [MoodleController::class, 'prueba']);
