<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mesa de Partes Virtual</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    @include('include.plugins-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

    <style>
        :root {
            --primary-color: #1e40af;
            --secondary-color: #f8fafc;
            --accent-color: #3b82f6;
            --text-primary: #1f2937;
            --text-secondary: #6b7280;
            --border-color: #e5e7eb;
            --success-color: #10b981;
        }

        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            color: var(--text-primary);
        }

        .main-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            overflow: hidden;
        }

        .header-section {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--accent-color) 100%);
            color: white;
            padding: 2rem;
            text-align: center;
            position: relative;
        }

        .header-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
            opacity: 0.3;
        }

        .header-content {
            position: relative;
            z-index: 1;
        }

        .header-title {
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .header-subtitle {
            font-size: 1.1rem;
            opacity: 0.9;
            font-weight: 400;
        }

        .form-section {
            padding: 2.5rem;
        }

        .section-card {
            background: white;
            border: 2px solid var(--border-color);
            border-radius: 12px;
            padding: 2rem;
            margin-bottom: 2rem;
            transition: all 0.3s ease;
            position: relative;
        }

        .section-card:hover {
            border-color: var(--accent-color);
            box-shadow: 0 8px 25px -8px rgba(59, 130, 246, 0.15);
        }

        .section-title {
            background: var(--primary-color);
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 600;
            font-size: 1.1rem;
            margin: -2rem -2rem 2rem -2rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .form-label {
            font-weight: 600;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }

        .form-control, .form-select {
            border: 2px solid var(--border-color);
            border-radius: 8px;
            padding: 0.75rem 1rem;
            font-size: 0.95rem;
            transition: all 0.3s ease;
            background: white;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--accent-color);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
            outline: none;
        }

        .input-group-text {
            background: var(--primary-color);
            border: 2px solid var(--primary-color);
            color: white;
            border-radius: 0 8px 8px 0;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .input-group-text:hover {
            background: var(--accent-color);
            border-color: var(--accent-color);
        }

        .required-field::after {
            content: ' *';
            color: #dc2626;
            font-weight: bold;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--accent-color) 100%);
            border: none;
            padding: 0.875rem 2rem;
            border-radius: 8px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(59, 130, 246, 0.4);
        }

        .form-check-input:checked {
            background-color: var(--success-color);
            border-color: var(--success-color);
        }

        .form-check-label {
            font-size: 0.9rem;
            color: var(--text-secondary);
        }

        .file-upload-area {
            border: 2px dashed var(--border-color);
            border-radius: 8px;
            padding: 1.5rem;
            text-align: center;
            transition: all 0.3s ease;
            background: #f8fafc;
        }

        .file-upload-area:hover {
            border-color: var(--accent-color);
            background: #f1f5f9;
        }

        @media (max-width: 768px) {
            .header-title {
                font-size: 2rem;
            }
            
            .form-section {
                padding: 1.5rem;
            }
            
            .section-card {
                padding: 1.5rem;
            }
        }
    </style>
</head>

<body>
    <div class="container-fluid py-4">
        <div class="row justify-content-center">
            <div class="col-12 col-xl-10">
                <div class="main-container">
                    <!-- Header Section -->
                    <div class="header-section">
                        <div class="header-content">
                            <div class="d-flex align-items-center justify-content-center mb-3">
                                <i class="fas fa-building fa-2x me-3"></i>
                                <div>
                                    <h1 class="header-title mb-0 text-white">Mesa de Partes Virtual</h1>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Form Section -->
                    <div class="form-section">
                        <form class="needs-validation" id="form" name="form" novalidate>
                            @csrf
                            <div class="row">
                                <!-- Consultar Tramite -->
                                <div class="col-lg-12">
                                    <div class="section-card pb-0 mb-0">
                                        <div class="section-title bg-dark mb-0">
                                            <div class="me-2">
                                            CONSULTA TU TRAMITE AQUÍ
                                            </div>
                                            <div class="me-2">
                                                    <input id="txt-codigo_tramite" name="txt-codigo_tramite" type="text" class="form-control" placeholder="Ingrese el codigo de trámite">
                                            </div>
                                            <button id="btnConsultarTD" type="button" class="btn btn-primary btn-sm">Consultar</button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Datos del Solicitante -->
                                <div class="col-lg-6">
                                    <div class="section-card">
                                        <div class="section-title">
                                            <i class="fas fa-user"></i>
                                            DATOS DEL SOLICITANTE
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label for="txt_td_tipo_solicitante" class="form-label required-field">Tipo de Solicitante</label>
                                                <select id="txt_td_tipo_solicitante" name="txt_td_tipo_solicitante" class="form-control form-select" required>
                                                    <option selected disabled value="">Seleccione una opción</option>
                                                </select>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <label for="txt_ruc" class="form-label required-field">Nro de RUC</label>
                                                <div class="input-group">
                                                    <input id="txt_ruc" name="txt_ruc" type="text" class="form-control" required>
                                                    <span class="input-group-text" id="btn-querydata1" title="Consultar SUNAT">
                                                        <i class="fa fa-search"></i>
                                                    </span>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <label for="txt_razon_social" class="form-label required-field">Razón Social</label>
                                                <input id="txt_razon_social" name="txt_razon_social" type="text" class="form-control" required>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_identification_type" class="form-label required-field">Tipo de Documento</label>
                                                <select id="txt_identification_type" name="txt_identification_type" class="form-control form-select" required>
                                                    <option selected disabled value="">Seleccione una opción</option>
                                                </select>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_numero_documento" class="form-label required-field">Número de Documento</label>
                                                <div class="input-group">
                                                    <input id="txt_numero_documento" name="txt_numero_documento" type="text" class="form-control" required>
                                                    <span class="input-group-text" id="btn-querydata2" title="Consultar RENIEC">
                                                        <i class="fa fa-search"></i>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_apellido_pa" class="form-label required-field">Apellido Paterno</label>
                                                <input id="txt_apellido_pa" name="txt_apellido_pa" type="text" class="form-control" required>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_apellido_ma" class="form-label required-field">Apellido Materno</label>
                                                <input id="txt_apellido_ma" name="txt_apellido_ma" type="text" class="form-control" required>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_nombres" class="form-label required-field">Nombres</label>
                                                <input id="txt_nombres" name="txt_nombres" type="text" class="form-control" required>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_correo" class="form-label required-field">Correo Electrónico</label>
                                                <input id="txt_correo" name="txt_correo" type="email" class="form-control" placeholder="ejemplo@correo.com" required>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_celular" class="form-label required-field">Celular</label>
                                                <input id="txt_celular" name="txt_celular" type="tel" class="form-control" placeholder="999 999 999" required>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_direccion" class="form-label required-field">Dirección</label>
                                                <input id="txt_direccion" name="txt_direccion" type="text" class="form-control" required>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-4 mb-3">
                                                <label for="txt_departamento" class="form-label required-field">Departamento</label>
                                                <select id="txt_departamento" name="txt_departamento" class="form-control form-select" required>
                                                    @include('include.combobox.departamento')
                                                </select>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <label for="txt_provincia" class="form-label required-field">Provincia</label>
                                                <select id="txt_provincia" name="txt_provincia" class="form-control form-select" required>
                                                    <option selected disabled value="">Seleccione opción</option>
                                                </select>
                                            </div>
                                            
                                            <div class="col-md-4 mb-3">
                                                <label for="txt_distrito" class="form-label required-field">Distrito</label>
                                                <select id="txt_distrito" name="txt_distrito" class="form-control form-select" required>
                                                    <option selected disabled value="">Seleccione opción</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Datos del Documento -->
                                <div class="col-lg-6">
                                    <div class="section-card">
                                        <div class="section-title">
                                            <i class="fas fa-file-alt"></i>
                                            DATOS DEL DOCUMENTO
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_td_tipo" class="form-label required-field">Tipo de Trámite</label>
                                                <select id="txt_td_tipo" name="txt_td_tipo" class="form-control form-select" required>
                                                    <option selected disabled value="">Seleccione una opción</option>
                                                </select>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_area" class="form-label required-field">Área a la que se dirige</label>
                                                <select id="txt_area" name="txt_area" class="form-control form-select" required>
                                                    <option selected disabled value="">Seleccione un área</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="mb-3">
                                            <label for="txt_asunto" class="form-label required-field">Asunto</label>
                                            <input id="txt_asunto" name="txt_asunto" class="form-control" placeholder="Ingrese fundamentación de la solicitud" required>
                                        </div>

                                        <div class="mb-3">
                                            <label for="txt_documentos" class="form-label required-field">Descripcion</label>
                                            <textarea id="txt_documentos" name="txt_documentos" rows="3" class="form-control" placeholder="Ingrese fundamentación de la solicitud" required></textarea>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_folios" class="form-label required-field">N° Folios</label>
                                                <input id="txt_folios" name="txt_folios" type="number" class="form-control" placeholder="Digite la cantidad de hojas" min="1" max="99" required>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="txt_fechadoc" class="form-label required-field">Fecha documento</label>
                                                <input id="txt_fechadoc" name="txt_fechadoc" type="date" class="form-control" value="2025-09-24" required>
                                            </div>
                                        </div>

                                        <div class="mb-4">
                                            <label for="documento" class="form-label required-field">Inserte Documento</label>
                                            <div class="file-upload-area">
                                                <i class="fas fa-cloud-upload-alt fa-2x text-muted mb-2"></i>
                                                <p class="text-muted mb-2">Arrastra tu archivo aquí o haz clic para seleccionar</p>
                                                <input class="form-control" type="file" id="documento" name="documento" accept=".pdf" required>
                                                <small class="text-muted">Solo archivos PDF (máx. 10MB)</small>
                                            </div>
                                        </div>

                                        <div class="mb-4">
                                            <div class="form-check">
                                                <input id="check_tyc" name="check_tyc" type="checkbox" class="form-check-input" required>
                                                <label class="form-check-label required-field" for="check_tyc">
                                                    Acepto los términos y condiciones
                                                </label>
                                            </div>
                                        </div>

                                        <div class="text-center">
                                            <button id="btnRegistrarTD" type="submit" class="btn btn-primary btn-lg">
                                                <i class="fas fa-paper-plane me-2"></i>
                                                Enviar Trámite
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalConsulta" class="modal fade" tabindex="-1" aria-labelledby="modalConsultaLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalConsultaLabel">Detalles del Trámite</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <fieldset style="border: 1px groove #ddd !important; padding: 0 1.4em 1.4em 1.4em !important; margin: 0 0 1.5em 0 !important; -webkit-box-shadow: 0px 0px 0px 0px #000; box-shadow: 0px 0px 0px 0px #000;">
                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-6 mb-3">
                                    <label for="txt-td_codigo" class="form-label text-primary">Código de Trámite
                                        Documentario
                                    </label>
                                    <input id="txt-td_codigo" name="txt-td_codigo" placeholder="--" type="text"
                                        class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-6 mb-3">
                                    <label for="txt-td_estado" class="form-label text-primary">Estado
                                    </label>
                                    <input id="txt-td_estado" name="txt-td_estado" placeholder="--" type="text"
                                        class="form-control form-control-sm fw-bold" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div id="div-txt-nota" class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-nota" class="form-label text-primary">Nota
                                    </label>
                                    <input id="txt-nota" name="txt-nota" placeholder="--" type="text"
                                        class="form-control form-control-sm text-uppercase" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-6 mb-3">
                                    <label for="txt-td_tipo" class="form-label text-primary">Tipo de
                                        Trámite
                                    </label>
                                    <input id="txt-td_tipo" name="txt-td_tipo" placeholder="--" type="text"
                                        class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-6 mb-3">
                                    <label for="txt-area" class="form-label text-primary">Área Actual
                                    </label>
                                    <input id="txt-area" name="txt-area" placeholder="--" type="text"
                                        class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                    <label for="txt-td_tipo_solicitante" class="form-label text-primary">Tipo
                                        Solicitante
                                    </label>
                                    <input id="txt-td_tipo_solicitante" name="txt-td_tipo_solicitante" placeholder="--"
                                        type="text" class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                                {{-- field --}}
                                <div class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                    <label for="txt-identification_type" class="form-label text-primary">Tipo de
                                        Documento
                                    </label>
                                    <input id="txt-identification_type" name="txt-identification_type" placeholder="--"
                                        type="text" class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                                {{-- field --}}
                                <div class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                    <label for="txt-numero_documento" class="form-label text-primary">Número de
                                        Documento
                                    </label>
                                    <input id="txt-numero_documento" name="txt-numero_documento" placeholder="--"
                                        type="text" class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                    <label for="txt-apellido_pa" class="form-label text-primary">Apellido Paterno
                                    </label>
                                    <input id="txt-apellido_pa" name="txt-apellido_pa" placeholder="--" type="text"
                                        class="form-control form-control-sm text-uppercase" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                                {{-- field --}}
                                <div class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                    <label for="txt-apellido_ma" class="form-label text-primary">Apellido Materno
                                    </label>
                                    <input id="txt-apellido_ma" name="txt-apellido_ma" placeholder="--" type="text"
                                        class="form-control form-control-sm text-uppercase" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                                {{-- field --}}
                                <div class="col-xl-4 col-md-4 col-sm-4 col-12 mb-3">
                                    <label for="txt-nombres" class="form-label text-primary">Nombres
                                    </label>
                                    <input id="txt-nombres" name="txt-nombres" placeholder="--" type="text"
                                        class="form-control form-control-sm text-uppercase" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-direccion" class="form-label text-primary">Dirección
                                    </label>
                                    <input id="txt-direccion" name="txt-direccion" placeholder="--" type="text"
                                        class="form-control form-control-sm text-uppercase" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-correo" class="form-label text-primary">Correo eléctronico
                                    </label>
                                    <input id="txt-correo" name="txt-correo" placeholder="--" type="text"
                                        class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>

                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-celular" class="form-label text-primary">Celular
                                    </label>
                                    <input id="txt-celular" name="txt-celular" placeholder="--" type="text"
                                        class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>

                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-asunto" class="form-label text-primary">Asunto
                                    </label>
                                    <textarea id="txt-asunto" name="txt-asunto" rows="2" class="form-control" placeholder="--" disabled></textarea>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-documentos" class="form-label text-primary">Documentos
                                        que se
                                        adjuntan</label>
                                    <textarea id="txt-documentos" name="txt-documentos" rows="2" class="form-control" placeholder="--" disabled></textarea>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>

                            {{-- row --}}
                            <div class="row m-0 p-0 col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-folios" class="form-label text-primary">N°
                                        Folios
                                    </label>
                                    <input id="txt-folios" name="txt-folios" placeholder="--" type="text"
                                        class="form-control form-control-sm" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>

                                {{-- field --}}
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fechadoc" class="form-label text-primary">Fecha
                                        documento
                                    </label>
                                    <input id="txt-fechadoc" name="txt-fechadoc" placeholder="--" type="text"
                                        class="form-control form-control-sm text-uppercase" autocomplete="off" disabled>
                                    @include('include.div.invalid-feedback')
                                    {{-- mensaje de error campo vacio --}}
                                </div>
                            </div>
                        </fieldset>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    @include('include.plugins-scripts')

    <script>
        // File upload enhancement
        document.getElementById('documento').addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const fileSize = file.size / 1024 / 1024; // MB
                if (fileSize > 20) {
                    alert('El archivo es demasiado grande. Máximo 20MB.');
                    e.target.value = '';
                }
            }
        });
    </script>
    
    <!--  Page JS -->
    @vite(['resources/js/tramite_documentario/registrar.js'])
    @vite(['resources/js/common/combobox/ubigeo_online.js']);
</body>

</html>
