<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Trámite Documentario</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            Registrar Trámite
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="form-validation">
                                <!-- Column starts -->
                                <div class="col-xl-12">
                                    <div class="card" id="accordion-three">

                                        <div class="card-header flex-wrap px-3 text-center">
                                            <div class="text-center">
                                                <h4 class="card-title"><i class="fas fa-cog fa-spin"></i> Mesa de partes
                                                    Virtual</h4>
                                            </div>
                                        </div>

                                        @include('tramite_documentario.registrar.form')

                                    </div>
                                </div>
                                <!-- Column ends -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <form class="needs-validation" id="formModal">
        @csrf
        <div id="modalConsulta" class="modal fade" tabindex="-1" aria-labelledby="modalConsultaLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalConsultaLabel">Detalles del Trámite</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="codigo" class="form-label text-primary">Código</label>
                                    <input id="codigo" name="codigo" type="text"
                                        class="form-control form-control-md text-uppercase fw-bold" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="tipo" class="form-label text-primary">Tipo</label>
                                    <input id="tipo" name="tipo" type="text" class="form-control form-control-md"
                                        readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="area" class="form-label text-primary">Área</label>
                                    <input id="area" name="area" type="text" class="form-control form-control-md"
                                        readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="estado" class="form-label text-primary">Estado</label>
                                    <input id="estado" name="estado" type="text"
                                        class="form-control form-control-md fw-bold" readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="solicitante" class="form-label text-primary">Datos del Solicitante</label>
                                    <textarea id="solicitante" name="solicitante" rows="7" class="form-control form-control-md" readonly></textarea>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="asunto" class="form-label text-primary">Asunto</label>
                                    <textarea id="asunto" name="asunto" rows="2" class="form-control form-control-md" readonly></textarea>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="documentos" class="form-label text-primary">Documentos</label>
                                    <textarea id="documentos" name="documentos" rows="2" class="form-control form-control-md" readonly></textarea>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="folios" class="form-label text-primary">Folios</label>
                                    <input id="folios" name="folios" type="number" class="form-control form-control-md"
                                        readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="fecha" class="form-label text-primary">Fecha</label>
                                    <input id="fecha" name="fecha" type="text" class="form-control form-control-md"
                                        readonly>
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="info_nota_respuesta" class="form-label text-primary">Comentario
                                        Respuesta</label>
                                    <input id="info_nota_respuesta" name="info_nota_respuesta" type="text"
                                        class="form-control form-control-md" readonly>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    @vite(['resources/js/login/logout.js']);


    <!--  Page JS -->
    @vite(['resources/js/admin/tramite_documentario/registrar.js'])

    @vite(['resources/js/common/combobox/td_tipos.js'])
    @vite(['resources/js/common/combobox/areas.js'])

</body>

</html>
