<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <!-- Meta -->
    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <title>Trámite Documentario</title>
    @include('include.datatable-styles')
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@48,400,0,0">
    <link href="{{ asset('/css/style_inscripcion.css') }}" rel="stylesheet">
</head>

<body class="body h-100">
    <div class="authincation d-flex flex-column flex-lg-row flex-column-fluid">
        <div class="login-aside text-center  d-flex flex-column flex-row-auto">
            <div class="d-flex flex-column-auto flex-column pt-lg-40 pt-15 align-items-center">
                <div class="text-center mb-lg-4 mb-2 pt-5 logo">
                    <img src="{{ asset('/images/institucion/logo-circle.png') }}" alt="">
                </div>
                <h3 class="mb-2 text-white">Consulta Trámite</h3>
                <p class="mb-4"><br>Sistema de Gestión Académica</p>
                <a href="{{ route('login') }}" class="btn btn-info btn-sm col-xl-6 mb-3">
                    <i class="fa-solid fa-user fa-flip"></i> Iniciar Sesión
                </a>
            </div>
        </div>
        <div class="container-fluid d-flex flex-column justify-content-start">
            <div class="row">
                <div class="col-xl-12">
                    <div class="row py-3">
                        <div class="form-validation">
                            @include('tramite_documentario.consulta.form')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--**********************************
        Scripts
    ***********************************-->

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>

    <!-- vendors -->
    <script src="{{ asset('/vendor/global/global.min.js') }}"></script>
    <script src="{{ asset('/vendor/jquery-nice-select/js/jquery.nice-select.min.js') }}"></script>
    <script src="{{ asset('/vendor/bootstrap-select/dist/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>
    <script src="{{ asset('/vendor/sweetalert2/dist/sweetalert2.min.js') }}"></script>
    <!-- Toastr -->
    <script src="{{ asset('/vendor/toastr/js/toastr.min.js') }}"></script>
    <!-- All init script -->
    <script src="{{ asset('/js/plugins-init/toastr-init.js') }}"></script>


    @vite(['resources/js/tramite_documentario/consulta.js']);


    <script>
        // Agrega un manejador de eventos para cambiar los iconos al hacer clic en el encabezado
        $('.card-header').click(function() {
            $(this).find('.fa-plus-circle, .fa-minus-circle').toggleClass('d-none');
        });
    </script>
</body>

</html>
