
<?php
date_default_timezone_set('America/Lima');

$fecha_actual = date('d/m/Y');
$hora_actual = date('H:i A');
$i = 1;
set_time_limit(180); // Aumenta el límite de tiempo a 120 segundos

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- <link href="{{ public_path('/css/pdf.css') }}" rel="stylesheet"> -->
    <title>Reporte generado</title>
    <style>
        html{
            margin: 0;
            padding: 25px 20px 15px 20px;
        }
        body {
            margin: 0;
            padding: 25px 20px 15px 20px;
            background:rgba(234, 234, 234, 0.188)
        }

        thead tr th{
            font-size: 0.3cm;
            text-align: center;
            border: 1px solid black;
            vertical-align: middle;
        }

        tbody tr td{
            font-size: 0.3cm;
            padding-left: 0.2cm;
            border: 1px solid black;
        }

        tbody tr #text_n, #text_dni, #text_nombres, #text_camp {
            padding-left: 5px;
            text-align: center;
        }

        /* ESTILOS PERSONALIZADOS POR ID */
        thead tr #thead_n{
            text-align: center;
            width: 0.5cm;
        }

        thead tr #thead_dni{
            width: 2cm;
        }

        thead tr #thead_nombres{
            width: 4cm;
        }

        thead tr #thead_camp{
            width: 2cm;
        }


        #contenedor{
            width: 100%;
            display: inline-block; /*Convertimos al menú en flexbox*/
            justify-content: center; /*Con esto le indicamos que margine todos los items que se encuentra adentro hacia la derecha e izquierda*/
            align-items: center;
        }

        #div_img {
            display: flex; /* Esto coloca los contenedores de las imágenes en línea */
            justify-content: space-between; /* Esto separa las imágenes a los extremos opuestos */
        }

        #logo1 {
            flex: 0 1 auto; /* Esto permite que el primer logo ocupe espacio según su tamaño */
        }

        #logo2 {
            flex: 0 1 auto; /* Esto permite que el segundo logo ocupe espacio según su tamaño */
        }

        #div_titulo {
            width: 100%;
            padding: 2px 2px 2px 2px;
        }

        #div_titulo #titulo_fechahora{
            width: 100%;
            text-align: right;
            font-size: 12px;
            font-weight: bold;
            font-family: "Times New Roman";
        }

        #div_titulo #div_titulo_reporte{
            width: 100%;
            text-align: center;
        }

        #titulo_reporte{
            font-size: 22px;
            font-family: "Times New Roman";
            font-weight: bold;
        }

        #div_contenido{
            width: 100%;
            margin-top: 5px;
            padding: 1px 1px 1px 1px;
        }
    </style>
</head>

<body>
    @auth
        {{-- USUARIO ADMIN --}}
        @if (Auth::User()->usertype_id == 1)
            <div id="contenedor">
                <div id="div_img">
                    <div id="logo1">
                        <img src="{{ asset('images/institucion/logo.png') }}"  width="150px" height="100px" style="float: left;">
                    </div>
                    <div id="logo2">
                        <img src="{{ asset('images/institucion/minedu.jpg') }}" width="200px" height="40px" style="float: right;">
                    </div>
                    <br><br><br><br>
                </div>
                <div id="div_titulo">
                    <div id="div_titulo_fechahora">
                        <p id="titulo_fechahora">Fecha: <?php echo $fecha_actual; ?>  Hora: <?php echo $hora_actual; ?></p>
                    </div>
                    @foreach ($infos as $info)
                    <div id="div_titulo_reporte">
                        <p id="titulo_reporte"> REPORTE DE EGRESADOS</p>
                    </div>
                </div>
                <div  id="div_contenido">
                    <table class="table">
                        <tbody>
                            <tr>
                                <td style="width: 30px; background-color: rgb(180, 180, 180)">DRE-GRE:</td>
                                <td style="width: 80px">{{ $institutions['dre'] }}</td>
                                <td style="width: 20px; background-color: rgb(180, 180, 180)" >Nombre:</td>
                                <td style="width: 80px">{{ $institutions['nombre'] }}</td>
                            </tr>
                            <tr>
                                <td style="width: 30px; background-color: rgb(180, 180, 180)">Departamento:</td>
                                <td style="width: 80px">{{ $institutions['departamento'] }}</td>
                                <td style="width: 20px; background-color: rgb(180, 180, 180)">Código Programa:</td>
                                <td style="width: 80px">{{ $info->codprograma }}</td>
                            </tr>
                            <tr>
                                <td style="width: 30px; background-color: rgb(180, 180, 180)">Provincia:</td>
                                <td style="width: 80px">{{ $institutions['provincia'] }}</td>
                                <td style="width: 20px; background-color: rgb(180, 180, 180)">Programa:</td>
                                <td style="width: 80px">{{ $info->programa }}</td>
                            </tr>
                            <tr>
                                <td style="width: 30px; background-color: rgb(180, 180, 180)">Distrito:</td>
                                <td style="width: 80px">{{ $institutions['distrito'] }}</td>
                                <td style="width: 20px; background-color: rgb(180, 180, 180)">Nivel Formativo:</td>
                                <td style="width: 80px">{{ $info->nivel_formativo }}</td>
                            </tr>
                            <tr>
                                <td style="width: 30px; background-color: rgb(180, 180, 180)">Centro Poblado:</td>
                                <td style="width: 40px">{{ $institutions['centro'] }}</td>
                                <td style="width: 20px; background-color: rgb(180, 180, 180)">Plan de estudios:</td>
                                <td style="width: 80px">{{ $info->plan }} - {{ $info->tipo }}</td>
                            </tr>
                            <tr>
                                <td style="width: 30px; background-color: rgb(180, 180, 180)">Direccion del local:</td>
                                <td style="width: 40px" colspan="3">{{ $institutions['direccion'] }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <div  id="div_contenido">
                    <table class="table">
                        <thead>
                            <tr>
                                <th id="thead_n">N°</th>
                                <th id="thead_dni">Identificacion</th>
                                <th id="thead_nombres">Nombre del estudiante</th>
                                <th id="thead_camp">Año ingreso</th>
                                <th id="thead_camp">Correo</th>
                                <th id="thead_camp">Celular</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($estudiantes as $estudiante)
                                <tr>
                                    <td id="text_n">{{ $i++ }}</td>
                                    <td id="text_dni">{{ $estudiante->identificacion }}</td>
                                    <td id="text_nombres">{{ $estudiante->estudiante }}</td>
                                    <td id="text_camp">{{ $estudiante->anho_ingreso }}</td>
                                    <td id="text_camp">{{ $estudiante->correo }}</td>
                                    <td id="text_camp">{{ $estudiante->celular }}</td>
                                </tr>
                             @endforeach
                        </tbody>
                </table>
                </div>
            </div>
        @endif
    @endauth
</body>

</html>
