<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Récord de Notas</title>
    <style>
        @page {
            size: A4 portrait;
            margin: 1.5cm;
        }

        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            line-height: 1.4;
        }

        .container {
            width: 100%;
        }

        .header-table {
            width: 100%;
            margin-bottom: 15px;
            border-collapse: collapse;
        }

        .header-table td {
            vertical-align: middle;
            text-align: center;
        }

        .header-table .logo-cell {
            width: 25%;
        }

        .header-table .logo-cell-center {
            width: 50%;
        }

        .header-table .photo-cell {
            width: 25%;
            height: 100px;
            border: 1px solid #ccc;
            text-align: center;
            vertical-align: middle;
            font-size: 10px;
            color: #999;
        }

        .header-table img {
            max-height: 70px;
            max-width: 100%;
        }

        .title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .info-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
            font-size: 12px;
        }

        .info-table td {
            padding: 4px;
        }

        .grades-table {
            width: 100%;
            margin: 20px 0;
            font-size: 10px;
            border-collapse: collapse;
            page-break-inside: auto;
        }

        .grades-table th,
        .grades-table td {
            border: 0.5px solid #333;
            text-align: center;
            padding: 4px;
        }

        .grades-table th {
            background-color: #f2f2f2;
        }

        .grades-table tr {
            page-break-inside: avoid;
        }

        .ciclo-header td {
            background-color: #e0e0e0;
            text-align: left;
            font-weight: bold;
            padding-left: 10px;
        }

        .fecha {
            text-align: right;
            margin: 20px 0;
            font-size: 12px;
        }

        .signature {
            text-align: center;
            margin-top: 40px;
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            bottom: 0;
        }

        .signature-line {
            border-top: 1px solid #000;
            width: 200px;
            margin: 0 auto;
        }

        .signature-title {
            font-weight: bold;
            margin-top: 5px;
            font-size: 16px;
        }

        .signature-subtitle {
            font-size: 13px;
        }
    </style>
</head>

<body>
    <div class="container">
        <table class="header-table">
            <tr>
                <td class="logo-cell">
                    @if (!empty($logoSrc))
                        <img src="{{ $logoSrc }}">
                    @endif
                </td>
                <td class="logo-cell-center">
                    @if (!empty($mineduLogoSrc))
                        <img src="{{ $mineduLogoSrc }}">
                    @endif
                </td>
                <td class="photo-cell">
                    FOTO
                </td>
            </tr>
        </table>

        <div class="title">
            RÉCORD ACADÉMICO DE NOTAS
        </div>

        <table class="info-table">
            <tr>
                <td width="15%"><strong>ESTUDIANTE:</strong></td>
                <td width="55%">{{ $estudiantes->estudiante }}</td>
                <td width="15%"><strong>PROGRAMA:</strong></td>
                <td width="15%">{{ $estudiantes->programa }}</td>
            </tr>
            <tr>
                <td><strong>DNI:</strong></td>
                <td>{{ $estudiantes->identificacion }}</td>
                <td><strong>PLAN EST.:</strong></td>
                <td>{{ $estudiantes->plan }}</td>
            </tr>
        </table>

        <table class="grades-table">
            <thead>
                <tr>
                    <th width="8%">CICLO</th>
                    <th width="10%">CÓDIGO</th>
                    <th>CURSO</th>
                    <th width="8%">CRÉD.</th>
                    <th width="8%">HORAS</th>
                    <th width="10%">NOTA FINAL</th>
                    <th width="12%">PERIODO LEC.</th>
                </tr>
            </thead>
            <tbody>
                @php $currentCiclo = null; @endphp
                @forelse ($cursos as $curso)
                    @if ($curso->ciclo != $currentCiclo)
                        <tr class="ciclo-header">
                            <td colspan="7">
                                CICLO {{ $curso->ciclo }}
                            </td>
                        </tr>
                        @php $currentCiclo = $curso->ciclo; @endphp
                    @endif
                    <tr>
                        <td>{{ $curso->ciclo }}</td>
                        <td>{{ $curso->codcurso }}</td>
                        <td style="text-align: left; padding-left: 5px;">{{ $curso->nombre_curso }}</td>
                        <td>{{ $curso->creditos }}</td>
                        <td>{{ $curso->horas }}</td>
                        <td>{{ $curso->promedio_final ?? '--' }}</td>
                        <td>{{ $curso->semestre ?? '--' }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="7">No hay cursos registrados para este estudiante.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>

        <div class="fecha">
            Lugar y fecha: {{ $institutions['direccion'] }}, {{ $estudiantes->fecha_actual }}
        </div>

        <div class="signature">
            <div class="signature-line"></div>
            <div class="signature-title">SECRETARÍA ACADÉMICA</div>
        </div>
    </div>
</body>

</html>
