<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Matrícula</title>
    <style>
        html {
            font-family: Verdana, Geneva, Tahoma, sans-serif;
            padding: 10px;
            margin: 10px;
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bott     om: 20px;
        }
        
        .header .left-logo img {
            height: 60px;
        }
        
        .header .center-text {
            text-align: center;
            font-size: 14px;
        }
        
        .header .right-logo {
            text-align: right;
        }
        
        .header .right-logo img {
            height: 60px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
            /* table-layout: fixed; Fija el ancho de las columnas */
        }
        
        .table, .table th, .table td {
            border: 1px solid black;
        }
        
        .table th, .table td {+
            padding: 3px; /* Reduce el espacio interno para evitar desbordamientos */
            text-align: center;
            font-size: 9px;
            word-wrap: break-word; /* Asegura que el texto se ajuste dentro de la celda */
        }
        
        .vertical-text {
            line-height: 1; /* Mejora el espaciado entre líneas en texto vertical */
        }
        
        .table th.vertical-text {
            width: 40px; /* Ancho fijo para columnas verticales */
            /* height: auto;  */
        }
        
        .header {
            text-align: center;
            font-weight: bold;
        }
    
        .subheader {
            text-align: center;
            font-size: 14px;
            font-weight: bold;
        }
    </style>      
</head>
<body>
    
    <div class="header">
        <div class="left-logo">
            <!-- <img src="{{ asset('/images/institucion/minedu.png') }}" alt="Logo del Ministerio"> -->
        </div>
        <div class="center-text">
            <th colspan="12" class="header">OFICIAL<br>REGISTRO DE MATRÍCULA<br>Periodo {{ $info->semestre }}</th>
        </div>
        <div class="right-logo">
            <!-- <img src="{{ route('institucion.cargarLogo') }}" alt="Logo del Ministerio"> -->
        </div>
    </div>
    <br>
    <table class="table">
        <thead>
            <tr>
                <td colspan="12" class="subheader fs-20" style="background-color: #c0c0c0">Datos de la Institución</td>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">DRE-GRE</td>
                <td colspan="2">{{ $institutions['dre'] }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Nombre</td>
                <td colspan="6">{{ $institutions['nombre'] }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Departamento</td>
                <td colspan="2">{{ $institutions['departamento'] }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Programa</td>
                <td colspan="6">{{ $info->programa }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Provincia</td>
                <td colspan="2">{{ $institutions['provincia'] }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Nivel formativo</td>
                <td colspan="6">{{ $info->nivel_formativo }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Distrito</td>
                <td colspan="2">{{ $institutions['distrito'] }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Periodo de clases</td>
                <td colspan="6">{{ $info->semestre }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Centro poblado</td>
                <td colspan="2">{{ $institutions['centro'] }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Semestre Académico</td>
                <td colspan="2">{{ $info->periodo }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Plan de estudios</td>
                <td colspan="2">{{ $info->plan }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Nombre de la sede</td>
                <td colspan="10">{{ $institutions['sede'] }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Turno</td>
                <td colspan="2">{{ $institutions['turno'] }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Sección</td>
                <td colspan="6">{{ $institutions['seccion'] }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Dirección de la sede principal</td>
                <td colspan="10">{{ $institutions['direccion'] }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Dirección del local</td>
                <td colspan="10">{{ $institutions['direccion_local'] }}</td>
            </tr>
            <tr>
                <td colspan="2" style="background-color: #c0c0c0">Número de código modular</td>
                <td colspan="2">{{ $institutions['codigo_modular'] }}</td>
                <td colspan="2" style="background-color: #c0c0c0">Tipo de gestión</td>
                <td colspan="6">{{ $institutions['tipo_gestion'] }}</td>
            </tr>
        </tbody>
    </table>
    <br>
    @php
        $array_cursos = [];
        $i = 1;
    @endphp
    <table class="table">
        <thead>
            <tr>
                <th rowspan="2" style="width: 15px;">N°</th>
                <th rowspan="2" style="width: 50px;">DNI</th>
                <th rowspan="2">APELLIDOS Y NOMBRES</th>
                <th rowspan="2" style="width: 30px;">SEXO<br>(F/M)</th>
                <th rowspan="2" style="width: 30px;">EDAD</th>
                <th rowspan="2" style="width: 50px;">PERSONA CON DISCAPACIDAD<br>(SI/NO)</th>
                <th colspan="{{ $total_filas->cantidad }}">cursos</th>
            </tr>
            <tr>
                @foreach ($cursos as $curso)
                    @php $array_cursos[] = str_replace(' ', '_', $curso->nombre) @endphp
                    <th class="vertical-text" style="width: 40px; padding: 3px;">{{ $curso->nombre }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            @foreach ($estudiantes as $estudiante)
            <tr>
                <td>@php echo $i++; @endphp</td>
                <td>{{ $estudiante->nroidenti }}</td>
                <td>{{ $estudiante->estudiante }}</td>
                <td>{{ $estudiante->sexo }}</td>
                <td>{{ $estudiante->edad }}</td>
                <td>NO</td>
                @foreach ($array_cursos as $array_curso)
                    <td>{{ $estudiante->$array_curso }}</td>
                @endforeach
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
